/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.lib;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.scada.configuration.infrastructure.AbstractFactoryDriver;
import org.eclipse.scada.configuration.infrastructure.Driver;
import org.eclipse.scada.configuration.infrastructure.EquinoxDriver;
import org.eclipse.scada.configuration.infrastructure.Node;
import org.eclipse.scada.configuration.infrastructure.Options;
import org.eclipse.scada.configuration.infrastructure.World;
import org.eclipse.scada.configuration.infrastructure.lib.DriverFactory;
import org.eclipse.scada.configuration.infrastructure.lib.DriverValidator;
import org.eclipse.scada.configuration.infrastructure.lib.Worlds;
import org.eclipse.scada.configuration.security.Configuration;
import org.eclipse.scada.configuration.utils.Containers;
import org.eclipse.scada.configuration.world.osgi.ConfigurationAdministratorExporter;
import org.eclipse.scada.configuration.world.osgi.DataAccessExporter;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;

public abstract class AbstractEquinoxDriverFactory<T extends org.eclipse.scada.configuration.world.Driver & EquinoxApplication>
implements DriverFactory {
    private final List<DriverValidator<EquinoxDriver>> validators = new LinkedList<DriverValidator<EquinoxDriver>>();

    protected abstract void configureDriver(AbstractFactoryDriver var1, T var2, Map<Node, org.eclipse.scada.configuration.world.Node> var3);

    protected abstract T createDriver();

    public AbstractEquinoxDriverFactory() {
        this.validators.add(new DriverValidator<EquinoxDriver>(){

            @Override
            public void validate(IValidationContext ctx, EquinoxDriver driver, Collection<IStatus> result) {
                World world = (World)Containers.findContainer((EObject)driver, World.class);
                Options options = world.getOptions();
                if (driver.getUserService() == null && options == null || options.getDefaultUserService() == null) {
                    result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, Arrays.asList(driver), (int)2, (int)0, (String)"Neither the driver has set a user service nor is there a default in the global options", (Object[])new Object[0]));
                }
                if (AbstractEquinoxDriverFactory.this.findConfiguration(driver, world) == null) {
                    result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, Arrays.asList(driver), (int)2, (int)1, (String)"Neither the driver has set a security policy nor is there a default in the root", (Object[])new Object[0]));
                }
            }
        });
    }

    protected void addValidator(DriverValidator<EquinoxDriver> validator) {
        this.validators.add(validator);
    }

    @Override
    public org.eclipse.scada.configuration.world.Driver createDriver(World world, AbstractFactoryDriver driver, Map<Node, org.eclipse.scada.configuration.world.Node> nodes) {
        T result = this.createDriver();
        EquinoxDriver eDriver = (EquinoxDriver)driver;
        DataAccessExporter exporter = OsgiFactory.eINSTANCE.createDataAccessExporter();
        exporter.setName("exporter");
        ((EquinoxApplication)result).getExporter().add((Object)exporter);
        exporter.getEndpoints().add((Object)Worlds.createDaEndpoint(world.getOptions(), (Driver)driver));
        ConfigurationAdministratorExporter caExporter = OsgiFactory.eINSTANCE.createConfigurationAdministratorExporter();
        caExporter.setName("caExporter");
        caExporter.getEndpoints().add((Object)Worlds.createEndpoint(world.getOptions().getBaseCaNgpPort() + eDriver.getInstanceNumber(), "CA Exporter"));
        ((EquinoxApplication)result).getExporter().add((Object)caExporter);
        Worlds.addUserService(result, eDriver.getUserService(), world.getOptions());
        ((EquinoxApplication)result).setSecurityConfiguration(this.findConfiguration(eDriver, world));
        this.configureDriver(driver, result, nodes);
        return result;
    }

    private Configuration findConfiguration(EquinoxDriver eDriver, World world) {
        if (eDriver.getSecurityConfiguration() != null) {
            return eDriver.getSecurityConfiguration();
        }
        if (world != null) {
            return world.getDefaultSecurityConfiguration();
        }
        return null;
    }

    @Override
    public IStatus validate(IValidationContext ctx, AbstractFactoryDriver driver) {
        if (!(driver instanceof EquinoxDriver)) {
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)driver, null, (String)"Driver factory of type {0} can only process driver of type {1}", (Object[])new Object[]{this.getClass().getSimpleName(), EquinoxDriver.class.getSimpleName()});
        }
        Collection<IStatus> problems = this.validateDriver(ctx, (EquinoxDriver)driver);
        if (problems.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, problems);
    }

    protected Collection<IStatus> validateDriver(IValidationContext ctx, EquinoxDriver driver) {
        LinkedList<IStatus> result = new LinkedList<IStatus>();
        this.performValidation(ctx, driver, result);
        return result;
    }

    protected void performValidation(IValidationContext ctx, EquinoxDriver driver, Collection<IStatus> result) {
        for (DriverValidator<EquinoxDriver> validator : this.validators) {
            validator.validate(ctx, driver, result);
        }
    }
}

