/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.lib.internal;

import java.util.Collection;
import java.util.List;
import org.eclipse.scada.configuration.generator.Profiles;
import org.eclipse.scada.configuration.infrastructure.SystemPropertyUserService;
import org.eclipse.scada.configuration.infrastructure.UserEntry;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.profile.Profile;
import org.eclipse.scada.configuration.world.osgi.profile.ProfileFactory;
import org.eclipse.scada.configuration.world.osgi.profile.SystemProperty;
import org.eclipse.scada.utils.str.StringHelper;

public class SystemPropertiesUserServiceProcessor {
    private final SystemPropertyUserService userService;

    public SystemPropertiesUserServiceProcessor(SystemPropertyUserService userService) {
        this.userService = userService;
    }

    public void process(EquinoxApplication app) {
        Profile profile = Profiles.createOrGetCustomizationProfile((EquinoxApplication)app);
        SystemProperty prop = ProfileFactory.eINSTANCE.createSystemProperty();
        prop.setKey("org.eclipse.scada.sec.provider.plain.property.data");
        prop.setValue(SystemPropertiesUserServiceProcessor.makeValue((List<UserEntry>)this.userService.getUsers()));
        profile.getProperty().add((Object)prop);
        Profiles.addStartBundle((Profile)profile, (String)"org.eclipse.scada.sec.provider.plain.property");
    }

    private static String makeValue(List<UserEntry> users) {
        StringBuilder sb = new StringBuilder();
        for (UserEntry user : users) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            if (user.getName().contains(":")) {
                throw new IllegalArgumentException("User name must not contain ':'");
            }
            if (user.getPassword().contains(":")) {
                throw new IllegalArgumentException("Password must not contain ':'");
            }
            sb.append(user.getName());
            sb.append(':');
            sb.append(user.getPassword());
            sb.append(':');
            sb.append(StringHelper.join((Collection)user.getRoles(), (String)","));
        }
        return sb.toString();
    }
}

