/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.memory.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.scada.configuration.memory.Attribute;
import org.eclipse.scada.configuration.memory.BitType;
import org.eclipse.scada.configuration.memory.ByteOrder;
import org.eclipse.scada.configuration.memory.Float32Type;
import org.eclipse.scada.configuration.memory.MemoryFactory;
import org.eclipse.scada.configuration.memory.MemoryPackage;
import org.eclipse.scada.configuration.memory.TypeDefinition;
import org.eclipse.scada.configuration.memory.TypeSystem;
import org.eclipse.scada.configuration.memory.UnsignedInteger16Type;
import org.eclipse.scada.configuration.memory.UnsignedInteger32Type;
import org.eclipse.scada.configuration.memory.UnsignedInteger8Type;
import org.eclipse.scada.configuration.memory.UserDefinedType;
import org.eclipse.scada.configuration.memory.Variable;
import org.eclipse.scada.configuration.memory.impl.AttributeImpl;
import org.eclipse.scada.configuration.memory.impl.BitTypeImpl;
import org.eclipse.scada.configuration.memory.impl.Float32TypeImpl;
import org.eclipse.scada.configuration.memory.impl.TypeDefinitionImpl;
import org.eclipse.scada.configuration.memory.impl.TypeSystemImpl;
import org.eclipse.scada.configuration.memory.impl.UnsignedInteger16TypeImpl;
import org.eclipse.scada.configuration.memory.impl.UnsignedInteger32TypeImpl;
import org.eclipse.scada.configuration.memory.impl.UnsignedInteger8TypeImpl;
import org.eclipse.scada.configuration.memory.impl.UserDefinedTypeImpl;
import org.eclipse.scada.configuration.memory.impl.VariableImpl;

public class MemoryFactoryImpl
extends EFactoryImpl
implements MemoryFactory {
    public static MemoryFactory init() {
        try {
            MemoryFactory theMemoryFactory = (MemoryFactory)EPackage.Registry.INSTANCE.getEFactory("http://eclipse.org/SCADA/Configuration/Memory");
            if (theMemoryFactory != null) {
                return theMemoryFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new MemoryFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createTypeDefinition();
            }
            case 1: {
                return this.createBitType();
            }
            case 3: {
                return this.createVariable();
            }
            case 4: {
                return this.createAttribute();
            }
            case 5: {
                return this.createFloat32Type();
            }
            case 7: {
                return this.createUserDefinedType();
            }
            case 8: {
                return this.createUnsignedInteger16Type();
            }
            case 10: {
                return this.createUnsignedInteger32Type();
            }
            case 11: {
                return this.createUnsignedInteger8Type();
            }
            case 12: {
                return this.createTypeSystem();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 14: {
                return this.createByteOrderFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 14: {
                return this.convertByteOrderToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public TypeDefinition createTypeDefinition() {
        TypeDefinitionImpl typeDefinition = new TypeDefinitionImpl();
        return typeDefinition;
    }

    @Override
    public UserDefinedType createUserDefinedType() {
        UserDefinedTypeImpl userDefinedType = new UserDefinedTypeImpl();
        return userDefinedType;
    }

    @Override
    public UnsignedInteger16Type createUnsignedInteger16Type() {
        UnsignedInteger16TypeImpl unsignedInteger16Type = new UnsignedInteger16TypeImpl();
        return unsignedInteger16Type;
    }

    @Override
    public UnsignedInteger32Type createUnsignedInteger32Type() {
        UnsignedInteger32TypeImpl unsignedInteger32Type = new UnsignedInteger32TypeImpl();
        return unsignedInteger32Type;
    }

    @Override
    public UnsignedInteger8Type createUnsignedInteger8Type() {
        UnsignedInteger8TypeImpl unsignedInteger8Type = new UnsignedInteger8TypeImpl();
        return unsignedInteger8Type;
    }

    @Override
    public TypeSystem createTypeSystem() {
        TypeSystemImpl typeSystem = new TypeSystemImpl();
        return typeSystem;
    }

    public ByteOrder createByteOrderFromString(EDataType eDataType, String initialValue) {
        ByteOrder result = ByteOrder.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertByteOrderToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public BitType createBitType() {
        BitTypeImpl bitType = new BitTypeImpl();
        return bitType;
    }

    @Override
    public Variable createVariable() {
        VariableImpl variable = new VariableImpl();
        return variable;
    }

    @Override
    public Attribute createAttribute() {
        AttributeImpl attribute = new AttributeImpl();
        return attribute;
    }

    @Override
    public Float32Type createFloat32Type() {
        Float32TypeImpl float32Type = new Float32TypeImpl();
        return float32Type;
    }

    @Override
    public MemoryPackage getMemoryPackage() {
        return (MemoryPackage)this.getEPackage();
    }

    @Deprecated
    public static MemoryPackage getPackage() {
        return MemoryPackage.eINSTANCE;
    }
}

