/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.modbus.lib;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.scada.configuration.infrastructure.AbstractFactoryDriver;
import org.eclipse.scada.configuration.infrastructure.Device;
import org.eclipse.scada.configuration.infrastructure.EquinoxDriver;
import org.eclipse.scada.configuration.infrastructure.lib.AbstractEquinoxDriverFactory;
import org.eclipse.scada.configuration.infrastructure.lib.DeviceTypeValidator;
import org.eclipse.scada.configuration.infrastructure.lib.DriverValidator;
import org.eclipse.scada.configuration.infrastructure.lib.Worlds;
import org.eclipse.scada.configuration.memory.TypeSystem;
import org.eclipse.scada.configuration.memory.manager.MemoryManagerFactory;
import org.eclipse.scada.configuration.memory.manager.MemoryManagerModule;
import org.eclipse.scada.configuration.modbus.ModbusBlock;
import org.eclipse.scada.configuration.modbus.ModbusDevice;
import org.eclipse.scada.configuration.modbus.ModbusDriver;
import org.eclipse.scada.configuration.modbus.ModbusFactory;
import org.eclipse.scada.configuration.modbus.ModbusMaster;
import org.eclipse.scada.configuration.modbus.ModbusSlave;
import org.eclipse.scada.configuration.modbus.ProtocolType;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.Node;

public class DriverFactoryImpl
extends AbstractEquinoxDriverFactory<ModbusDriver> {
    private static final int MIN_ADDRESS = 0;
    private static final int MAX_ADDRESS = 65536;

    public DriverFactoryImpl() {
        this.addValidator((DriverValidator)new DeviceTypeValidator(ModbusDevice.class));
    }

    protected ModbusDriver createDriver() {
        return ModbusFactory.eINSTANCE.createModbusDriver();
    }

    protected void configureDriver(AbstractFactoryDriver driver, ModbusDriver result, Map<org.eclipse.scada.configuration.infrastructure.Node, Node> nodes) {
        MemoryManagerModule manager = MemoryManagerFactory.eINSTANCE.createMemoryManagerModule();
        result.getModules().add((Object)manager);
        for (Device device : driver.getDevices()) {
            if (!(device instanceof ModbusDevice)) {
                throw new IllegalStateException(String.format("Device type %s is not supported", device.getClass()));
            }
            if (manager.getTypeSystem() == null) {
                manager.setTypeSystem(((ModbusDevice)device).getTypeSystem());
            } else if (((ModbusDevice)device).getTypeSystem() != null && manager.getTypeSystem().getName().equals(((ModbusDevice)device).getTypeSystem().getName())) {
                throw new IllegalStateException("All modbus devices must share the same type system");
            }
            this.createDevice(driver, result, (ModbusDevice)device, nodes);
        }
    }

    protected void createDevice(AbstractFactoryDriver driver, ModbusDriver result, ModbusDevice device, Map<org.eclipse.scada.configuration.infrastructure.Node, Node> nodes) {
        ModbusMaster master = ModbusFactory.eINSTANCE.createModbusMaster();
        master.setId(device.getName());
        result.getMasters().add((Object)master);
        Endpoint ep = Worlds.createEndpoint((int)device.getPort(), (String)"Modbus Device Endpoint");
        master.setEndpoint(ep);
        master.setProtocolType(device.getProtocolType());
        master.setInterFrameDelay(device.getInterFrameDelay());
        Node node = nodes.get(device.getNode());
        if (node == null) {
            throw new IllegalStateException(String.format("Node %s was not found in target model", device.getNode()));
        }
        node.getEndpoints().add((Object)ep);
        master.getSlaves().addAll(EcoreUtil.copyAll((Collection)device.getSlaves()));
    }

    protected void performValidation(IValidationContext ctx, EquinoxDriver driver, Collection<IStatus> result) {
        super.performValidation(ctx, driver, result);
        HashSet<TypeSystem> typeSystems = new HashSet<TypeSystem>();
        for (Device device : driver.getDevices()) {
            if (!(device instanceof ModbusDevice)) {
                throw new IllegalStateException(String.format("Device type %s is not supported", device.getClass()));
            }
            typeSystems.add(((ModbusDevice)device).getTypeSystem());
            this.validateDevice(ctx, driver, (ModbusDevice)device, result);
        }
        if (typeSystems.size() > 1) {
            result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)driver, null, (String)"All modbus devices of one driver instance must share the same type system ({})", (Object[])new Object[]{typeSystems}));
        }
    }

    private void validateDevice(IValidationContext ctx, EquinoxDriver driver, ModbusDevice device, Collection<IStatus> result) {
        if (device.getProtocolType() == ProtocolType.TCP && device.getInterFrameDelay() != null) {
            result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)device, null, (String)"InterFrameDelay must not be set for TCP devices.", (Object[])new Object[0]));
        }
        for (ModbusSlave slave : device.getSlaves()) {
            if (slave.getUnitAddress() == 0 || slave.getUnitAddress() == 255) {
                result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)slave, null, (String)"Unit address {} is invalid. Must be greater than 0x00 and less than 0xFF.", (Object[])new Object[]{slave.getUnitAddress()}));
            }
            for (ModbusBlock block : slave.getBlocks()) {
                if (block.getCount() <= 0) {
                    result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)block, null, (String)"Block size must be positive and greater than zero", (Object[])new Object[0]));
                }
                if (block.getPeriod() <= 0L) {
                    result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)block, null, (String)"Block polling period must be positive and greater than zero", (Object[])new Object[0]));
                }
                if (block.getTimeout() < 0L) {
                    result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)block, null, (String)"Block timeot must not be negative", (Object[])new Object[0]));
                }
                if (block.getStartAddress() < 0 || block.getStartAddress() >= 65536) {
                    result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)block, null, (String)"Block address must be between {} and {}", (Object[])new Object[]{0, 65536}));
                }
                if (block.getStartAddress() + block.getCount() < 65536) continue;
                result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)block, null, (String)"A start address of {} and block size of {} would read beyond the maximum.", (Object[])new Object[]{block.getStartAddress(), block.getCount()}));
            }
        }
    }
}

