/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.modbus.lib;

import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.configuration.modbus.ModbusBlock;
import org.eclipse.scada.configuration.modbus.ModbusDriver;
import org.eclipse.scada.configuration.modbus.ModbusMaster;
import org.eclipse.scada.configuration.modbus.ModbusSlave;
import org.eclipse.scada.configuration.modbus.ProtocolType;
import org.eclipse.scada.configuration.world.lib.oscar.EquinoxApplicationProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.utils.str.StringHelper;

public class ModbusDriverProcessor
extends EquinoxApplicationProcessor {
    private final ModbusDriver driver;

    public ModbusDriverProcessor(ModbusDriver driver) {
        super((EquinoxApplication)driver);
        this.driver = driver;
    }

    protected void processForContext(OscarContext ctx, IFolder output, IProgressMonitor monitor) throws Exception {
        for (ModbusMaster device : this.driver.getMasters()) {
            this.createDevice(ctx, device);
        }
    }

    private void createDevice(OscarContext ctx, ModbusMaster device) {
        HashMap<String, String> data = new HashMap<String, String>();
        String id = device.getId();
        data.put("host", device.getEndpoint().getNode().getHostName());
        data.put("port", "" + device.getEndpoint().getPortNumber());
        data.put("protocolType", device.getProtocolType().getLiteral());
        if (device.getProtocolType() != ProtocolType.TCP && device.getInterFrameDelay() != null) {
            data.put("interFrameDelay", "" + device.getInterFrameDelay());
        }
        ctx.addData("org.eclipse.scada.da.server.osgi.modbus.masterDevice", id, data);
        for (ModbusSlave slave : device.getSlaves()) {
            this.createSlave(ctx, device, slave);
        }
    }

    private void createSlave(OscarContext ctx, ModbusMaster master, ModbusSlave slave) {
        HashMap<String, String> data = new HashMap<String, String>();
        String id = slave.getId();
        data.put("modbus.master.id", master.getId());
        data.put("slave.id", "" + slave.getUnitAddress());
        data.put("dataOrder", "" + slave.getDataOrder());
        for (ModbusBlock block : slave.getBlocks()) {
            LinkedList<String> toks = new LinkedList<String>();
            toks.add(block.getBlockType().toString());
            toks.add("" + block.getStartAddress());
            toks.add("" + block.getCount());
            toks.add("" + block.getPeriod());
            toks.add("" + block.getTimeout());
            toks.add(block.getType().getName());
            data.put("block." + block.getId(), StringHelper.join(toks, (String)":"));
        }
        ctx.addData("org.eclipse.scada.da.server.osgi.modbus.slaveDevice", id, data);
    }
}

