/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.recipe.ui;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scada.configuration.recipe.Definition;
import org.eclipse.scada.configuration.recipe.lib.Builder;
import org.eclipse.scada.configuration.recipe.lib.Recipe;
import org.eclipse.scada.configuration.utils.ModelLoader;
import org.eclipse.scada.ui.databinding.AbstractSelectionHandler;
import org.eclipse.scada.ui.databinding.SelectionHelper;
import org.eclipse.scada.ui.utils.status.StatusHelper;

public class RunRecipeHandler
extends AbstractSelectionHandler {
    private final int MONITOR_FILE_AMOUNT = 100000;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IStructuredSelection sel = this.getSelection();
        WorkspaceJob job = new WorkspaceJob("Run recipes"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                return RunRecipeHandler.this.processFiles(sel, monitor);
            }
        };
        job.setUser(true);
        job.setSystem(false);
        job.schedule();
        return null;
    }

    private IStatus processFiles(IStructuredSelection selection, IProgressMonitor monitor) {
        List files = SelectionHelper.list((ISelection)selection, IFile.class);
        MultiStatus ms = new MultiStatus("org.eclipse.scada.configuration.recipe.ui", 0, null, null);
        monitor.beginTask("Running recipes...", files.size() * 100000);
        try {
            for (IFile file : files) {
                try {
                    monitor.setTaskName(String.format("Recipe: %s", file.getName()));
                    this.processFile(file, monitor);
                    ms.add((IStatus)new Status(0, "org.eclipse.scada.configuration.recipe.ui", String.format("Run recipe: %s", file.getName())));
                }
                catch (CoreException e) {
                    ms.add(e.getStatus());
                }
                catch (Exception e) {
                    ms.add(StatusHelper.convertStatus((String)"org.eclipse.scada.configuration.recipe.ui", (Throwable)e));
                }
            }
        }
        finally {
            monitor.done();
        }
        if (ms.getChildren().length == 1) {
            return ms.getChildren()[0];
        }
        return ms;
    }

    private void processFile(IFile file, IProgressMonitor monitor) throws Exception {
        IFolder output = file.getParent().getFolder((IPath)new Path("output"));
        if (output.exists()) {
            output.delete(true, monitor);
        }
        output.create(true, true, monitor);
        ModelLoader loader = new ModelLoader(Definition.class);
        Definition def = (Definition)loader.load(URI.createURI((String)file.getLocationURI().toString()));
        Builder builder = new Builder(def);
        Recipe recipe = builder.build();
        SubProgressMonitor pm = new SubProgressMonitor(monitor, 100000);
        try {
            HashMap<String, Object> initialContent = new HashMap<String, Object>();
            initialContent.put("progressMonitor", pm);
            initialContent.put("output", output);
            recipe.execute(initialContent, monitor);
        }
        finally {
            pm.done();
        }
    }
}

