/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.ui.project.template;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.ui.templates.PluginReference;
import org.eclipse.scada.configuration.ui.project.template.BaseTemplate;
import org.eclipse.scada.utils.collection.MapBuilder;

public class AEViewSection
extends BaseTemplate {
    private final List<ColumnInformation> defaultConfigurationConfiguration = new LinkedList<ColumnInformation>();

    public AEViewSection() {
        this.defaultConfigurationConfiguration.add(new ColumnInformation("Source Timestamp", true, 120, "sourceTimestamp", null));
        this.defaultConfigurationConfiguration.add(new ColumnInformation("Event Type", false, 120, "variant", new MapBuilder().put((Object)"key", (Object)"eventType").put((Object)"decoration", (Object)"MONITOR").build()));
        AEViewSection.addDefaultColumn(this.defaultConfigurationConfiguration, "Value", "value");
        AEViewSection.addDefaultColumn(this.defaultConfigurationConfiguration, "Monitor Type", "monitorType");
        AEViewSection.addDefaultColumn(this.defaultConfigurationConfiguration, "Item", "item");
        AEViewSection.addDefaultColumn(this.defaultConfigurationConfiguration, "Item Description", "itemDescription");
        AEViewSection.addDefaultColumn(this.defaultConfigurationConfiguration, "Message", "message");
        AEViewSection.addDefaultColumn(this.defaultConfigurationConfiguration, "Actor Name", "actorName");
        this.defaultConfigurationConfiguration.add(new ColumnInformation("Actor Type", false, 120, "variant", new MapBuilder().put((Object)"decoration", (Object)"ACTOR").build()));
        AEViewSection.addDefaultColumn(this.defaultConfigurationConfiguration, "Priority", "priority");
        AEViewSection.addDefaultColumn(this.defaultConfigurationConfiguration, "Source", "source");
        AEViewSection.addDefaultColumn(this.defaultConfigurationConfiguration, "Hive", "hive");
        AEViewSection.addDefaultColumn(this.defaultConfigurationConfiguration, "System", "system");
        int i = 0;
        while (i < 10) {
            this.defaultConfigurationConfiguration.add(new ColumnInformation(String.format("Level %d", i), false, 90, "variant", new MapBuilder().put((Object)"key", (Object)String.format("level.%d", i)).build()));
            ++i;
        }
        this.defaultConfigurationConfiguration.add(new ColumnInformation("Entry Timestamp", true, 120, "entryTimestamp", null));
    }

    private static void addDefaultColumn(List<ColumnInformation> defaultConfigurationConfiguration, String label, String field) {
        defaultConfigurationConfiguration.add(new ColumnInformation(label, false, 120, "variant", new MapBuilder().put((Object)"key", (Object)field).build()));
    }

    public String getUsedExtensionPoint() {
        return null;
    }

    public String[] getNewFiles() {
        return new String[]{"resources/"};
    }

    public String getSectionId() {
        return "aeViews";
    }

    protected void updateModel(IProgressMonitor monitor) throws CoreException {
        IPluginModelFactory factory = this.model.getPluginFactory();
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtension ext = this.createExtension("org.eclipse.scada.ae.ui.views.configuration", false);
        plugin.add(ext);
        IPluginElement menu = this.createAlarmsMenu(factory, plugin);
        this.createMonitorView(factory, ext, menu, "monitors.not_ok", "All &Alarms");
        this.createMonitorView(factory, ext, menu, "monitors.ack_required", "A&cknowledge required");
        this.createMonitorView(factory, ext, menu, "monitors.warning.not_ok", "Only active warnings");
        this.createMonitorView(factory, ext, menu, "monitors.alarm.not_ok", "Only active alarms");
        this.addSeperator(factory, menu, "separator2");
        this.createEventView(factory, ext, menu, "events.all", "&Latest Events", 20000, "monitors.not_ok");
        this.createQueryView(factory, ext, menu, "eventHistoryView", "Query &Historic Events");
        this.createAlarmNotifier(factory, ext);
        this.createColumnInformation(factory, ext, "defaultConfiguration", this.defaultConfigurationConfiguration);
    }

    private void addSeperator(IPluginModelFactory factory, IPluginElement menu, String id) throws CoreException {
        IPluginElement ele = factory.createElement((IPluginObject)menu);
        ele.setName("separator");
        ele.setAttribute("name", this.makeId(id));
        ele.setAttribute("visible", "true");
    }

    protected IPluginElement createAlarmsMenu(IPluginModelFactory factory, IPluginBase plugin) throws CoreException {
        IPluginExtension menuExt = this.createExtension("org.eclipse.ui.menus", false);
        plugin.add(menuExt);
        IPluginElement menuEle = factory.createElement((IPluginObject)menuExt);
        menuExt.add((IPluginObject)menuEle);
        menuEle.setName("menuContribution");
        menuEle.setAttribute("locationURI", "menu:org.eclipse.ui.main.menu");
        IPluginElement menu = factory.createElement((IPluginObject)menuEle);
        menuEle.add((IPluginObject)menu);
        menu.setName("menu");
        menu.setAttribute("label", "Alarms");
        return menu;
    }

    private void createColumnInformation(IPluginModelFactory factory, IPluginExtension ext, String id, List<ColumnInformation> configuration) throws CoreException {
        IPluginElement ele = AEViewSection.addElement(factory, ext, "columnInformationDefinition", id);
        for (ColumnInformation ci : configuration) {
            IPluginElement colEle = factory.createElement((IPluginObject)ele);
            ele.add((IPluginObject)colEle);
            colEle.setName("columnInformation");
            colEle.setAttribute("initialSize", String.format("%d", ci.getInitialSize()));
            colEle.setAttribute("sortable", ci.isSortable() ? "true" : "false");
            colEle.setAttribute("label", ci.getLabel());
            colEle.setAttribute("type", ci.getType());
            if (ci.getParameters() == null) continue;
            for (Map.Entry<String, String> entry : ci.getParameters().entrySet()) {
                IPluginElement colPara = factory.createElement((IPluginObject)colEle);
                colEle.add((IPluginObject)colPara);
                colPara.setName("columnParameter");
                colPara.setAttribute("key", entry.getKey());
                colPara.setAttribute("value", entry.getValue());
            }
        }
    }

    private void createAlarmNotifier(IPluginModelFactory factory, IPluginExtension ext) throws CoreException {
        IPluginElement ele = factory.createElement((IPluginObject)ext);
        ext.add((IPluginObject)ele);
        ele.setName("alarmNotifier");
        ele.setAttribute("connectionId", this.makeConnectionId("da"));
        ele.setAttribute("prefix", "ae.server.info");
        ele.setAttribute("soundFile", "resources/alert.wav");
        IPluginElement cmd1 = factory.createElement((IPluginObject)ele);
        ele.add((IPluginObject)cmd1);
        cmd1.setName("ackAlarmsAvailableCommand");
        cmd1.setAttribute("id", "org.eclipse.scada.ui.utils.showView");
        AEViewSection.addParameter(factory, cmd1, "org.eclipse.scada.ui.utils.showView.viewId", String.format("org.eclipse.scada.ae.ui.views.views.monitors:%s", this.makeId("monitors.ack_required")));
        IPluginElement cmd2 = factory.createElement((IPluginObject)ele);
        ele.add((IPluginObject)cmd2);
        cmd2.setName("alarmsAvailableCommand");
        cmd2.setAttribute("id", "org.eclipse.scada.ui.utils.showView");
        AEViewSection.addParameter(factory, cmd2, "org.eclipse.scada.ui.utils.showView.viewId", String.format("org.eclipse.scada.ae.ui.views.views.monitors:%s", this.makeId("monitors.not_ok")));
        IPluginExtension menuExt = this.createExtension("org.eclipse.ui.menus", false);
        this.model.getPluginBase().add(menuExt);
        IPluginElement menuEle = factory.createElement((IPluginObject)menuExt);
        menuEle.setName("menuContribution");
        menuEle.setAttribute("locationURI", "toolbar:org.eclipse.scada.core.ui.connection.login.verticalTrim");
        menuExt.add((IPluginObject)menuEle);
        IPluginElement sub = factory.createElement((IPluginObject)menuEle);
        menuEle.add((IPluginObject)sub);
        sub.setName("control");
        sub.setAttribute("class", "org.eclipse.scada.ae.ui.views.contributions.AlarmNotifier");
    }

    private void createQueryView(IPluginModelFactory factory, IPluginExtension ext, IPluginElement menu, String id, String label) throws CoreException {
        IPluginElement ele = factory.createElement((IPluginObject)ext);
        ele.setName("eventHistoryView");
        ele.setAttribute("id", this.makeId(id));
        ele.setAttribute("columnInformationDefinition", "defaultConfiguration");
        ele.setAttribute("connectionString", this.makeConnectionId("ae"));
        ele.setAttribute("connectionType", "ID");
        ele.setAttribute("label", this.clear(label));
        ext.add((IPluginObject)ele);
        this.createShowView(factory, menu, this.makeId(id), label, "org.eclipse.scada.ae.ui.views.views.eventhistory");
    }

    protected void createEventView(IPluginModelFactory factory, IPluginExtension ext, IPluginElement menu, String eventPoolQueryId, String label, int size, String monitorId) throws CoreException {
        IPluginElement ele = factory.createElement((IPluginObject)ext);
        ele.setName("eventPoolView");
        ele.setAttribute("id", this.makeId(eventPoolQueryId));
        ele.setAttribute("eventPoolQueryId", eventPoolQueryId);
        ele.setAttribute("columnInformationDefinition", "defaultConfiguration");
        ele.setAttribute("connectionString", this.makeConnectionId("ae"));
        ele.setAttribute("connectionType", "ID");
        ele.setAttribute("monitorQueryId", monitorId);
        ele.setAttribute("label", this.clear(label));
        ele.setAttribute("maxNumberOfEvents", String.format("%d", size));
        ext.add((IPluginObject)ele);
        this.createShowView(factory, menu, this.makeId(eventPoolQueryId), label, "org.eclipse.scada.ae.ui.views.views.eventpool");
    }

    protected void createMonitorView(IPluginModelFactory factory, IPluginExtension ext, IPluginElement menu, String monitorId, String label) throws CoreException {
        IPluginElement ele = factory.createElement((IPluginObject)ext);
        ele.setName("monitorView");
        ele.setAttribute("id", this.makeId(monitorId));
        ele.setAttribute("connectionString", this.makeConnectionId("ae"));
        ele.setAttribute("connectionType", "ID");
        ele.setAttribute("monitorQueryId", monitorId);
        ele.setAttribute("label", this.clear(label));
        ext.add((IPluginObject)ele);
        this.createShowView(factory, menu, this.makeId(monitorId), label, "org.eclipse.scada.ae.ui.views.views.monitors");
    }

    protected void createShowView(IPluginModelFactory factory, IPluginElement menu, String subViewId, String label, String viewId) throws CoreException {
        IPluginElement cmd = factory.createElement((IPluginObject)menu);
        menu.add((IPluginObject)cmd);
        cmd.setName("command");
        cmd.setAttribute("commandId", "org.eclipse.scada.ui.utils.showView");
        cmd.setAttribute("label", label);
        cmd.setAttribute("style", "push");
        IPluginElement para = factory.createElement((IPluginObject)cmd);
        cmd.add((IPluginObject)para);
        para.setName("parameter");
        para.setAttribute("name", "org.eclipse.scada.ui.utils.showView.viewId");
        para.setAttribute("value", String.format("%s:%s", viewId, subViewId));
    }

    private String clear(String label) {
        return label.replace("&", "");
    }

    @Override
    protected void fillDependencies(Collection<IPluginReference> dependencies, String schemaVersion) {
        dependencies.add((IPluginReference)new PluginReference("org.eclipse.scada.ae.ui.views", "0.1.0", 0));
    }

    private static final class ColumnInformation {
        private final String label;
        private final boolean sortable;
        private final int initialSize;
        private final String type;
        private final Map<String, String> parameters;

        public ColumnInformation(String label, boolean sortable, int initialSize, String type, Map<String, String> parameters) {
            this.label = label;
            this.sortable = sortable;
            this.initialSize = initialSize;
            this.type = type;
            this.parameters = parameters;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isSortable() {
            return this.sortable;
        }

        public int getInitialSize() {
            return this.initialSize;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }
    }
}

