/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.ui.project.template;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.templates.OptionTemplateSection;
import org.eclipse.pde.ui.templates.TemplateOption;
import org.eclipse.scada.configuration.ui.project.Activator;
import org.osgi.framework.Bundle;

public abstract class BaseTemplate
extends OptionTemplateSection {
    protected String pluginId;

    protected static IPluginElement addElement(IPluginModelFactory factory, IPluginElement parent, String name, String id) throws CoreException {
        IPluginElement element = factory.createElement((IPluginObject)parent);
        parent.add((IPluginObject)element);
        element.setName(name);
        return element;
    }

    protected static IPluginElement addElement(IPluginModelFactory factory, IPluginExtension parent, String name, String id) throws CoreException {
        IPluginElement element = factory.createElement((IPluginObject)parent);
        parent.add((IPluginObject)element);
        element.setName(name);
        if (id != null) {
            element.setAttribute("id", id);
        }
        return element;
    }

    protected static void addParameter(IPluginModelFactory factory, IPluginElement ele, String key, String value) throws CoreException {
        IPluginElement param = factory.createElement((IPluginObject)ele);
        param.setName("parameter");
        param.setAttribute("name", key);
        param.setAttribute("value", value);
        ele.add((IPluginObject)param);
    }

    protected String getFormattedPackageName(String id) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < id.length()) {
            char ch = id.charAt(i);
            if (buffer.length() == 0) {
                if (Character.isJavaIdentifierStart(ch)) {
                    buffer.append(Character.toLowerCase(ch));
                }
            } else if (Character.isJavaIdentifierPart(ch) || ch == '.') {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString().toLowerCase(Locale.ENGLISH);
    }

    protected ResourceBundle getPluginResourceBundle() {
        Bundle bundle = Platform.getBundle((String)Activator.getPluginId());
        return Platform.getResourceBundle((Bundle)bundle);
    }

    protected URL getInstallURL() {
        return Activator.getDefault().getInstallURL();
    }

    protected String getTemplateDirectory() {
        return "templates/scada/0.1";
    }

    protected String makeConnectionId(String tag) {
        return String.format("connection.%s.main", tag);
    }

    public IPluginReference[] getDependencies(String schemaVersion) {
        LinkedList<IPluginReference> deps = new LinkedList<IPluginReference>();
        deps.addAll(Arrays.asList(super.getDependencies(schemaVersion)));
        this.fillDependencies(deps, schemaVersion);
        return deps.toArray(new IPluginReference[deps.size()]);
    }

    protected abstract void fillDependencies(Collection<IPluginReference> var1, String var2);

    public boolean isDependentOnParentWizard() {
        return true;
    }

    protected void initializeFields(IFieldData data) {
        this.pluginId = data.getId();
    }

    public void initializeFields(IPluginModelBase model) {
        this.pluginId = model.getPluginBase().getId();
    }

    protected String makeId(String localId) {
        return this.getFormattedPackageName(String.format("%s.%s", this.pluginId, localId));
    }

    protected void flagErrorMessage(TemplateOption option, String newMessage, int newType) {
        int i = 0;
        while (i < this.getPageCount()) {
            WizardPage page = this.getPage(i);
            TemplateOption[] templateOptionArray = this.getOptions(i);
            int n = templateOptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                TemplateOption pageOption = templateOptionArray[n2];
                if (pageOption.equals(option)) {
                    page.setPageComplete(false);
                    page.setMessage(newMessage, newType);
                }
                ++n2;
            }
            ++i;
        }
    }
}

