/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.scada.configuration.recipe.lib.ExecutableContext;
import org.eclipse.scada.configuration.utils.Factories;
import org.eclipse.scada.configuration.utils.ModelLoader;
import org.eclipse.scada.configuration.world.Application;
import org.eclipse.scada.configuration.world.ApplicationNode;
import org.eclipse.scada.configuration.world.Node;
import org.eclipse.scada.configuration.world.Service;
import org.eclipse.scada.configuration.world.World;
import org.eclipse.scada.configuration.world.deployment.DeploymentMechanism;
import org.eclipse.scada.configuration.world.lib.NodeElementProcessor;
import org.eclipse.scada.configuration.world.lib.NodeElementProcessorFactory;
import org.eclipse.scada.configuration.world.lib.Nodes;
import org.eclipse.scada.configuration.world.lib.internal.Activator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldRunner {
    private static final String ATTR_CLASS = "class";
    private static final String ELE_FOR_CLASS = "forClass";
    private static final String ATTR_FOR_CLASS = "forClass";
    private static final Logger logger = LoggerFactory.getLogger(WorldRunner.class);
    private static final String ELE_NODE_ELEMENT_PROCESSOR = "nodeElementProcessor";
    @Inject
    private ExecutableContext context;

    private ExecutableContext getContext() {
        if (this.context != null) {
            return this.context;
        }
        return ExecutableContext.EMPTY;
    }

    public void processUri(URI input, IContainer output, IProgressMonitor monitor) throws Exception {
        logger.debug("Processing file: {}", (Object)input);
        monitor.setTaskName("Loading model");
        this.process(null, (World)new ModelLoader(World.class).load(input), output, monitor);
    }

    public void process(@Named(value="phase") String phase, World world, IContainer output, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Processing world", world.getNodes().size());
        for (Node node : world.getNodes()) {
            if (node instanceof ApplicationNode) {
                this.processNode(phase, world, (ApplicationNode)node, output, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    private void processNode(String phase, World world, ApplicationNode applicationNode, IContainer output, IProgressMonitor monitor) throws Exception {
        NodeElementProcessor processor;
        logger.debug("Processing node: {}", (Object)applicationNode);
        String name = Nodes.makeName((Node)applicationNode);
        IFolder nodeDir = output.getFolder((IPath)new Path(name));
        if (!nodeDir.exists()) {
            nodeDir.create(true, true, monitor);
        }
        for (Application app : applicationNode.getApplications()) {
            logger.debug("Processing application: {}", (Object)app);
            processor = this.createProcessor((EObject)app, world, applicationNode);
            processor.process(phase, nodeDir, monitor, this.getContext().getProperties());
        }
        for (DeploymentMechanism deploy : applicationNode.getDeployments()) {
            logger.debug("Processing deployment: {}", (Object)deploy);
            processor = this.createProcessor((EObject)deploy, world, applicationNode);
            processor.process(phase, nodeDir, monitor, this.getContext().getProperties());
        }
        for (Service service : applicationNode.getServices()) {
            logger.debug("Processing service: {}", (Object)service);
            processor = this.createProcessor((EObject)service, world, applicationNode);
            processor.process(phase, nodeDir, monitor, this.getContext().getProperties());
        }
    }

    private NodeElementProcessor createProcessor(EObject element, World world, ApplicationNode applicationNode) throws CoreException {
        EAnnotation an = element.eClass().getEAnnotation("http://eclipse.org/SCADA/Configuration/World");
        if (an != null && Boolean.parseBoolean((String)an.getDetails().get((Object)"ignore"))) {
            return new NodeElementProcessor(){

                @Override
                public void process(String phase, IFolder baseDir, IProgressMonitor monitor, Map<String, String> properties) throws Exception {
                }
            };
        }
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.scada.configuration.world.lib.generator");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            if (ele.getName().equals(ELE_NODE_ELEMENT_PROCESSOR) && this.isMatch(Activator.getDefault().getBundle().getBundleContext(), ele, element)) {
                NodeElementProcessorFactory factory = (NodeElementProcessorFactory)ele.createExecutableExtension("factoryClass");
                return factory.createProcessor(element, world, applicationNode);
            }
            ++n2;
        }
        throw new IllegalStateException(String.format("No processor found for element: %s", element));
    }

    private boolean isMatch(BundleContext ctx, IConfigurationElement ele, Object element) {
        if (this.isMatch(Factories.loadClass((BundleContext)ctx, (IConfigurationElement)ele, (String)"forClass"), element)) {
            return true;
        }
        IConfigurationElement[] iConfigurationElementArray = ele.getChildren("forClass");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            if (this.isMatch(Factories.loadClass((BundleContext)ctx, (IConfigurationElement)child, (String)ATTR_CLASS), element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isMatch(Class<?> clazz, Object element) {
        if (clazz == null) {
            return false;
        }
        return clazz.isAssignableFrom(element.getClass());
    }
}

