/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.world.ApplicationNode;
import org.eclipse.scada.configuration.world.lib.deployment.CommonHandler;
import org.eclipse.scada.configuration.world.lib.deployment.DebianHandler;
import org.eclipse.scada.configuration.world.lib.utils.CopyRecursive;
import org.eclipse.scada.configuration.world.lib.utils.Helper;
import org.eclipse.scada.configuration.world.osgi.profile.Profile;
import org.eclipse.scada.configuration.world.osgi.profile.ProfileFactory;
import org.eclipse.scada.configuration.world.osgi.profile.ProfilePackage;
import org.eclipse.scada.configuration.world.osgi.profile.SystemProperty;

public abstract class CommonPackageHandler
extends CommonHandler {
    public CommonPackageHandler(ApplicationNode applicationNode) {
        super(applicationNode);
    }

    @Override
    protected abstract void handleProcess(IFolder var1, IProgressMonitor var2, Map<String, String> var3) throws Exception;

    protected void createDrivers(IFolder nodeDir, IProgressMonitor monitor, File packageFolder, Map<String, String> replacements) throws IOException, Exception {
        for (String driverName : this.makeDriverList()) {
            this.createDriver(nodeDir, monitor, packageFolder, replacements, driverName);
        }
    }

    protected void createDriver(IFolder nodeDir, IProgressMonitor monitor, File packageFolder, Map<String, String> replacements, String driverName) throws IOException, Exception {
        File sourceDir = new File(nodeDir.getLocation().toFile(), driverName);
        File driverDir = new File(packageFolder, "src/etc/eclipsescada/drivers/" + driverName);
        replacements.put("driverName", driverName);
        this.processDriver(monitor, packageFolder, replacements, driverName, sourceDir, driverDir);
        replacements.remove("driverName");
    }

    protected void processDriver(IProgressMonitor monitor, File packageFolder, Map<String, String> replacements, String driverName, File sourceDir, File driverDir) throws IOException, Exception {
        driverDir.getParentFile().mkdirs();
        CopyRecursive rec = new CopyRecursive(sourceDir.toPath(), driverDir.toPath());
        Files.walkFileTree(sourceDir.toPath(), rec);
        Helper.createFile(new File(packageFolder, "src/etc/eclipsescada/drivers/" + driverName + "/logback.xml"), CommonPackageHandler.class.getResourceAsStream("templates/driver.logback.xml"), replacements, monitor);
        Helper.createFile(new File(packageFolder, "src/etc/eclipsescada/drivers/" + driverName + "/jvm.args"), CommonPackageHandler.class.getResourceAsStream("templates/jvm.args"), replacements, monitor);
    }

    protected void createEquinox(File sourceBase, File packageFolder, Map<String, String> replacements, IProgressMonitor monitor) throws Exception {
        for (String name : this.makeEquinoxList()) {
            replacements.put("appName", name);
            this.processEquinox(sourceBase, packageFolder, replacements, monitor, name);
            replacements.remove("appName");
        }
    }

    protected void processEquinox(File sourceBase, File packageFolder, Map<String, String> replacements, IProgressMonitor monitor, String name) throws IOException, Exception, FileNotFoundException {
        File source = new File(sourceBase, String.valueOf(name) + "/" + name + ".profile.xml");
        File target = new File(packageFolder, "src/usr/share/eclipsescada/profiles/" + name + ".profile.xml");
        target.getParentFile().mkdirs();
        Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        Helper.createFile(new File(packageFolder, "src/usr/share/eclipsescada/profiles/" + name + "/logback.xml"), DebianHandler.class.getResourceAsStream("templates/app.logback.xml"), replacements, monitor);
        File createFile = new File(packageFolder, "src/usr/bin/scada.create." + name);
        Helper.createFile(createFile, DebianHandler.class.getResourceAsStream("templates/scada.createApplication"), replacements, monitor);
        Helper.createFile(new File(packageFolder, "src/usr/share/eclipsescada/ca.bootstrap/bootstrap." + name + ".json"), (InputStream)new FileInputStream(new File(sourceBase, String.valueOf(name) + "/data.json")), monitor, false);
        createFile.setExecutable(true);
        this.patchProfile(name, target);
    }

    protected void patchProfile(String name, File file) throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createFileURI((String)file.toString()));
        r.load(null);
        Profile profile = (Profile)EcoreUtil.getObjectByType((Collection)r.getContents(), (EClassifier)ProfilePackage.Literals.PROFILE);
        SystemProperty bootstrap = ProfileFactory.eINSTANCE.createSystemProperty();
        bootstrap.setKey("org.eclipse.scada.ca.file.provisionJsonUrl");
        bootstrap.setValue("file:///usr/share/eclipsescada/ca.bootstrap/bootstrap." + name + ".json");
        profile.getProperty().add((Object)bootstrap);
        r.save(null);
    }
}

