/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment;

import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.scada.configuration.utils.TypeVisitor;
import org.eclipse.scada.configuration.utils.TypeWalker;
import org.eclipse.scada.configuration.world.Node;
import org.eclipse.scada.configuration.world.World;
import org.eclipse.scada.configuration.world.deployment.NodeMappingEntry;
import org.eclipse.scada.configuration.world.deployment.NodeMappings;

public class NodeMappingHandler
implements TypeVisitor<Node> {
    @Inject
    private World worldModel;
    @Inject
    private NodeMappings nodeMappings;

    public void execute(IProgressMonitor monitor) throws Exception {
        monitor.setTaskName("Mapping nodes");
        new TypeWalker(Node.class).walk((EObject)this.worldModel, (TypeVisitor)this);
    }

    public void visit(Node node) throws Exception {
        for (NodeMappingEntry entry : this.nodeMappings.getEntries()) {
            if (!entry.mapNode(node)) continue;
            return;
        }
        switch (this.nodeMappings.getFallbackMode()) {
            case IGNORE: {
                return;
            }
            case FAIL: {
                throw new IllegalStateException(String.format("No node mapping for: %s", node));
            }
        }
    }
}

