/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment.wix;

import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.eclipse.scada.configuration.generator.Profiles;
import org.eclipse.scada.configuration.world.lib.deployment.MsiHandler;
import org.eclipse.scada.configuration.world.lib.deployment.wix.MsiPlatform;
import org.eclipse.scada.configuration.world.lib.deployment.wix.XMLBase;
import org.eclipse.scada.configuration.world.osgi.profile.Profile;
import org.eclipse.scada.configuration.world.osgi.profile.SystemProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WixDeploymentSetupBuilder
extends XMLBase {
    private MsiPlatform platform = MsiPlatform.WIN32;
    private String version;
    private String manufacturer;
    private String upgradeCode;
    private String name;
    private final List<CommonDriverService> commonDrivers = new LinkedList<CommonDriverService>();
    private final List<EquinoxAppService> apps = new LinkedList<EquinoxAppService>();
    private final Set<String> components = new HashSet<String>();
    private Element caDir;
    private boolean useFirewall;
    private boolean useUserInterface;
    private File licenseFile;

    public void setUseFirewall(boolean useFirewall) {
        this.useFirewall = useFirewall;
    }

    public void setUseUserInterface(boolean useUserInterface) {
        this.useUserInterface = useUserInterface;
    }

    public void write(File base) throws Exception {
        Document doc = this.createXmlDocument();
        this.createDocument(doc, base);
        this.storeXmlDocument(doc, new File(base, "Setup.wxs"));
    }

    protected void createDocument(Document doc, File base) throws Exception {
        Element ele = doc.createElementNS("http://schemas.microsoft.com/wix/2006/wi", "Wix");
        doc.appendChild(ele);
        this.createProduct(doc, ele, base);
    }

    private void createProduct(Document doc, Element root, File base) throws Exception {
        Element ele = this.createElement(root, "Product");
        ele.setAttribute("Version", this.version);
        ele.setAttribute("Language", "1033");
        ele.setAttribute("Id", "*");
        ele.setAttribute("Manufacturer", this.manufacturer);
        ele.setAttribute("UpgradeCode", this.upgradeCode);
        ele.setAttribute("Name", this.name);
        this.createPackage(ele);
        this.createProperties(ele);
        this.createMedia(ele);
        this.createUpgrade(ele);
        this.createTargetDir(ele);
        this.createCommonDriverServices(ele, base);
        this.createEquinoxApplicationServices(ele, base);
        this.createLicense(base);
        this.createUserInterface(ele);
        this.createFeature(ele);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createLicense(File base) throws Exception {
        File targetFile = new File(new File(base, "resources"), "license.rtf");
        if (this.licenseFile != null) {
            if (!this.licenseFile.isFile()) throw new IllegalStateException(String.format("Specified license file could not be found (%s)", this.licenseFile.getAbsoluteFile()));
            Files.copy(this.licenseFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return;
        } else {
            this.writeLicense(targetFile, "Unspecified license!");
        }
    }

    private void writeLicense(File targetFile, String string) throws Exception {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter writer = new PrintWriter(targetFile, "US-ASCII");){
            writer.println("{\\rtf\\ansi");
            writer.println(string);
            writer.println("}");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void createUserInterface(Element product) {
        if (!this.useUserInterface) {
            return;
        }
        Element ui = this.createElement(product, "UIRef");
        ui.setAttribute("Id", "WixUI_Minimal");
        ui = this.createElement(product, "UIRef");
        ui.setAttribute("Id", "WixUI_ErrorProgressText");
        Element var = this.createElement(product, "WixVariable");
        var.setAttribute("Id", "WixUILicenseRtf");
        var.setAttribute("Value", "resources\\license.rtf");
    }

    private void createProperties(Element product) {
        Element p1 = this.createElement(product, "Property");
        p1.setAttribute("Id", "ES_JARS");
        Element cs1 = this.createElement(p1, "RegistrySearch");
        cs1.setAttribute("Id", "search.jars");
        cs1.setAttribute("Root", "HKLM");
        cs1.setAttribute("Type", "raw");
        cs1.setAttribute("Key", "SOFTWARE\\Eclipse SCADA Common Drivers");
        cs1.setAttribute("Name", "JarPath");
        Element p2 = this.createElement(product, "Property");
        p2.setAttribute("Id", "ES_EXTRA_JARS");
        Element cs2 = this.createElement(p2, "RegistrySearch");
        cs2.setAttribute("Id", "search.extra.jars");
        cs2.setAttribute("Root", "HKLM");
        cs2.setAttribute("Type", "raw");
        cs2.setAttribute("Key", "SOFTWARE\\Eclipse SCADA Common Drivers");
        cs2.setAttribute("Name", "ExtraJarPath");
        Element cond = this.createElement(product, "Condition");
        cond.setAttribute("Message", "You need to install the Eclipse SCADA Common Driver package first (jar)");
        cond.appendChild(product.getOwnerDocument().createCDATASection("ES_JARS OR Installed"));
        cond = this.createElement(product, "Condition");
        cond.setAttribute("Message", "You need to install the Eclipse SCADA Common Driver package first (extra-jars)");
        cond.appendChild(product.getOwnerDocument().createCDATASection("ES_EXTRA_JARS OR Installed"));
    }

    private void createCommonDriverServices(Element product, File base) throws Exception {
        Element dir = this.createElement(product, "DirectoryRef");
        dir.setAttribute("Id", "INSTALLDIR");
        Element dir2 = this.createElement(dir, "Directory");
        dir2.setAttribute("Id", "drivers");
        dir2.setAttribute("Name", "drivers");
        for (CommonDriverService cds : this.commonDrivers) {
            File driverResourceBase = new File(new File(new File(base, "resources"), "drivers"), cds.getName());
            driverResourceBase.mkdirs();
            this.createCommonDriverService(dir2, cds, driverResourceBase);
        }
    }

    private String makeServiceName(CommonDriverService cds) {
        return String.format("eclipse_scada_common_driver_%s", cds.getName());
    }

    private String makeServiceName(EquinoxAppService eas) {
        return String.format("eclipse_scada_app_%s", eas.getName());
    }

    private Element createComponent(Element parent, String id) {
        Element comp = this.createElement(parent, "Component");
        comp.setAttribute("Id", id);
        this.components.add(id);
        return comp;
    }

    private Element createCommonService(Element parent, String serviceName, String name, String description) {
        Element dir = this.createElement(parent, "Directory");
        dir.setAttribute("Id", serviceName);
        dir.setAttribute("Name", name);
        Element comp = this.createComponent(dir, serviceName);
        comp.setAttribute("Guid", "*");
        String fileId = String.valueOf(serviceName) + ".exe";
        Element file = this.createElement(comp, "File");
        file.setAttribute("Id", fileId);
        if (this.platform == MsiPlatform.WIN32) {
            file.setAttribute("Source", "unpack\\commons-daemon\\prunsrv.exe");
        } else {
            file.setAttribute("Source", "unpack\\commons-daemon\\amd64\\prunsrv.exe");
        }
        Element reg = this.createElement(comp, "RegistryKey");
        reg.setAttribute("Root", "HKLM");
        reg.setAttribute("Key", "SYSTEM\\CurrentControlSet\\services\\" + serviceName);
        reg = this.createElement(reg, "RegistryKey");
        reg.setAttribute("Key", "Parameters");
        reg.setAttribute("ForceCreateOnInstall", "yes");
        if (this.useFirewall) {
            Element fw = this.createElement(comp, "firewall", "FirewallException", "http://schemas.microsoft.com/wix/FirewallExtension");
            fw.setAttribute("Id", String.valueOf(serviceName) + "_fw");
            fw.setAttribute("Name", name);
            fw.setAttribute("Scope", "any");
            fw.setAttribute("Description", description);
            fw.setAttribute("Program", String.format("[#%s]", fileId));
        }
        return comp;
    }

    private void createProcrunService(Element comp, String serviceName, ServiceConfiguration serviceConfiguration) {
        Element reg = this.createElement(comp, "RegistryKey");
        reg.setAttribute("Root", "HKLM");
        if (this.platform == MsiPlatform.WIN32) {
            reg.setAttribute("Key", "SOFTWARE\\Apache Software Foundation\\Procrun 2.0\\" + serviceName);
        } else {
            reg.setAttribute("Key", "SOFTWARE\\Wow6432Node\\Apache Software Foundation\\Procrun 2.0\\" + serviceName);
        }
        reg = this.createElement(reg, "RegistryKey");
        reg.setAttribute("Key", "Parameters");
        Element regSub = this.createElement(reg, "RegistryKey");
        regSub.setAttribute("Key", "Java");
        this.addValue(regSub, "Jvm", "auto");
        this.addValue(regSub, "Classpath", serviceConfiguration.classpath);
        LinkedList<String> jvmProps = new LinkedList<String>();
        for (String key : serviceConfiguration.properties.stringPropertyNames()) {
            jvmProps.add(String.format("-D%s=%s", key, serviceConfiguration.properties.getProperty(key)));
        }
        if (serviceConfiguration.jvmArgs != null) {
            jvmProps.addAll(serviceConfiguration.jvmArgs);
        }
        this.addValues(regSub, "Options", jvmProps.toArray(new String[jvmProps.size()]));
        regSub = this.createElement(reg, "RegistryKey");
        regSub.setAttribute("Key", "Log");
        this.addValue(regSub, "Prefix", "common-driver-" + serviceName);
        this.addValue(regSub, "StdOutput", "auto");
        this.addValue(regSub, "StdError", "auto");
        regSub = this.createElement(reg, "RegistryKey");
        regSub.setAttribute("Key", "Start");
        this.addValue(regSub, "Class", serviceConfiguration.startClass);
        this.addValue(regSub, "Method", serviceConfiguration.startMethod);
        this.addValue(regSub, "Mode", "jvm");
        this.addValues(regSub, "Params", serviceConfiguration.startArguments);
        regSub = this.createElement(reg, "RegistryKey");
        regSub.setAttribute("Key", "Stop");
        this.addValue(regSub, "Class", serviceConfiguration.stopClass);
        this.addValue(regSub, "Method", serviceConfiguration.stopMethod);
        this.addValue(regSub, "Mode", "jvm");
        Element si = this.createElement(comp, "ServiceInstall");
        si.setAttribute("Id", "ServiceInstall_" + serviceName);
        si.setAttribute("DisplayName", serviceConfiguration.displayName);
        si.setAttribute("Description", serviceConfiguration.description);
        si.setAttribute("Name", serviceName);
        si.setAttribute("Type", "ownProcess");
        si.setAttribute("Start", "auto");
        si.setAttribute("ErrorControl", "normal");
        si.setAttribute("Vital", "yes");
        si.setAttribute("Arguments", String.format("//RS//%s", serviceName));
        Element sd = this.createElement(si, "ServiceDependency");
        sd.setAttribute("Id", "tcpip");
        Element sc = this.createElement(comp, "ServiceControl");
        sc.setAttribute("Id", "ServiceControl_" + serviceName);
        sc.setAttribute("Name", serviceName);
        sc.setAttribute("Stop", "both");
        sc.setAttribute("Remove", "uninstall");
        sc.setAttribute("Wait", "yes");
    }

    private void createEquinoxApplicationService(Element parent, EquinoxAppService eas, File resourceBase) throws Exception {
        Profile profile = eas.getProfile();
        String description = String.format("This is the Eclipse SCADA application instance '%s'", eas.getName());
        String serviceName = this.makeServiceName(eas);
        Element comp = this.createCommonService(parent, serviceName, eas.getName(), description);
        String cfgDirId = "cfg_" + serviceName;
        Element cfgDir = this.createElement(this.caDir, "Directory");
        cfgDir.setAttribute("Id", cfgDirId);
        cfgDir.setAttribute("Name", eas.getName());
        Element cfgDirComp = this.createComponent(cfgDir, "comp_" + cfgDirId);
        cfgDirComp.setAttribute("Guid", UUID.nameUUIDFromBytes(cfgDirId.getBytes()).toString());
        this.createElement(cfgDirComp, "CreateFolder");
        Element rmdir = this.createElement(cfgDirComp, "RemoveFolder");
        rmdir.setAttribute("Id", "rmdir_" + serviceName);
        rmdir.setAttribute("On", "uninstall");
        File startLevel = new File(resourceBase, "startLevels.properties");
        this.writeStartLevels(startLevel, profile);
        Element file = this.createElement(comp, "File");
        file.setAttribute("Id", "startLevels_" + serviceName);
        file.setAttribute("Source", String.format("resources\\apps\\%s\\startLevels.properties", eas.getName()));
        file = this.createElement(comp, "File");
        file.setAttribute("Id", "caBootstrap_" + serviceName);
        file.setAttribute("Source", String.format("resources\\apps\\%s\\ca.bootstrap.json", eas.getName()));
        Files.copy(new File(eas.getConfigurationBase(), "data.json").toPath(), new File(resourceBase, "ca.bootstrap.json").toPath(), StandardCopyOption.REPLACE_EXISTING);
        Properties p = new Properties();
        p.setProperty("eclipse.ignoreApp", "true");
        p.setProperty("osgi.noShutdown", "true");
        p.setProperty("osgi.syspath", String.format("[INSTALLDIR]\\apps\\%1$s\\plugins", eas.getName()));
        for (SystemProperty prop : profile.getProperty()) {
            p.setProperty(prop.getKey(), prop.getValue());
        }
        if (p.containsKey("logback.configurationFile")) {
            p.setProperty("logback.configurationFile", String.format("[INSTALLDIR]\\apps\\%s\\logback.xml", eas.getName()));
            this.createLogback(comp, eas, resourceBase);
        }
        if (p.containsKey("org.eclipse.scada.ca.file.root")) {
            p.setProperty("org.eclipse.scada.ca.file.root", String.format("[%s]\\ca", cfgDirId));
        }
        p.setProperty("org.osgi.framework.bootdelegation", "com.sun.script.javascript");
        p.setProperty("org.eclipse.scada.ca.file.provisionJsonUrl", String.format("file:[INSTALLDIR]\\apps\\%s\\ca.bootstrap.json", eas.getName()));
        ServiceConfiguration cfg = new ServiceConfiguration();
        cfg.displayName = "Eclipse SCADA Application: " + eas.getName();
        cfg.description = description;
        cfg.startClass = "org.eclipse.scada.utils.osgi.daemon.EclipseDaemon";
        cfg.startMethod = "start";
        cfg.stopClass = "org.eclipse.scada.utils.osgi.daemon.EclipseDaemon";
        cfg.stopMethod = "stop";
        cfg.properties = p;
        cfg.jvmArgs = profile.getJvmArguments();
        cfg.startArguments = profile.getArguments() != null ? (String[])profile.getArguments().toArray((Object[])new String[profile.getArguments().size()]) : null;
        cfg.classpath = String.format("[INSTALLDIR]\\apps\\%1$s\\daemon.jar;[INSTALLDIR]\\apps\\%1$s\\osgi.jar", eas.getName());
        this.createProcrunService(comp, serviceName, cfg);
    }

    private void createLogback(Element comp, EquinoxAppService eas, File resourceBase) throws Exception {
        Element file = this.createElement(comp, "File");
        String serviceName = this.makeServiceName(eas);
        file.setAttribute("Id", "logback.xml_" + serviceName);
        file.setAttribute("Source", String.format("resources\\apps\\%s\\logback.xml", eas.getName()));
        File logback = new File(resourceBase, "logback.xml");
        Throwable throwable = null;
        Object var8_9 = null;
        try (FileOutputStream out = new FileOutputStream(logback);){
            Resources.copy((URL)Resources.getResource(MsiHandler.class, (String)"templates/msi/app.logback.xml"), (OutputStream)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeStartLevels(File startLevel, Profile profile) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter writer = new PrintWriter(startLevel);){
            for (Map.Entry entry : Profiles.makeStartLevelMap((Profile)profile).entrySet()) {
                writer.println(String.format("%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void createCommonDriverService(Element parent, CommonDriverService cds, File resourceBase) throws Exception {
        Path configurationFile = new File(resourceBase, "exporter.xml").toPath();
        String description = String.format("This is the Eclipse SCADA common driver instance '%s'", cds.getName());
        Element comp = this.createCommonService(parent, this.makeServiceName(cds), cds.getName(), description);
        String serviceName = this.makeServiceName(cds);
        String fileIdConfiguration = "configuration_" + serviceName;
        Element file = this.createElement(comp, "File");
        file.setAttribute("Id", fileIdConfiguration);
        file.setAttribute("Source", String.format("resources\\drivers\\%s\\exporter.xml", cds.getName()));
        Files.copy(cds.getConfiguration().toPath(), configurationFile, new CopyOption[0]);
        ServiceConfiguration cfg = new ServiceConfiguration();
        cfg.displayName = "Eclipse SCADA Common Driver: " + cds.getName();
        cfg.description = description;
        cfg.stopClass = "org.eclipse.scada.da.server.exporter.Application";
        cfg.startClass = "org.eclipse.scada.da.server.exporter.Application";
        cfg.startMethod = "main";
        cfg.startArguments = new String[]{"[#" + fileIdConfiguration + "]"};
        cfg.stopMethod = "stop";
        cfg.properties = cds.getProps();
        cfg.classpath = "[ES_JARS]\\*;[ES_EXTRA_JARS]\\*";
        this.createProcrunService(comp, serviceName, cfg);
    }

    private void createEquinoxApplicationServices(Element product, File base) throws Exception {
        if (this.apps.isEmpty()) {
            return;
        }
        this.createAppCleanup(product);
        Element dir = this.createElement(product, "DirectoryRef");
        dir.setAttribute("Id", "apps");
        for (EquinoxAppService eqs : this.apps) {
            File resourceBase = new File(new File(new File(base, "resources"), "apps"), eqs.getName());
            resourceBase.mkdirs();
            this.createEquinoxApplicationService(dir, eqs, resourceBase);
        }
    }

    private void createAppCleanup(Element product) {
        Element ca = this.createElement(product, "CustomAction");
        ca.setAttribute("Id", "CleanupApps");
        ca.setAttribute("Directory", "INSTALLDIR");
        ca.setAttribute("Execute", "deferred");
        ca.setAttribute("Return", "ignore");
        ca.setAttribute("HideTarget", "no");
        ca.setAttribute("Impersonate", "no");
        ca.setAttribute("ExeCommand", "cmd /C \"rmdir /Q /S apps\"");
        Element ies = this.createElement(product, "InstallExecuteSequence");
        Element c = this.createElement(ies, "Custom");
        c.setAttribute("Action", "CleanupApps");
        c.setAttribute("After", "RemoveFiles");
        c.appendChild(product.getOwnerDocument().createTextNode("REMOVE=\"ALL\""));
    }

    private void addValue(Element reg, String key, String value) {
        Element ele = this.createElement(reg, "RegistryValue");
        ele.setAttribute("Type", "string");
        ele.setAttribute("Name", key);
        ele.setAttribute("Value", value);
    }

    private void addValues(Element reg, String key, String[] values) {
        if (values == null || values.length <= 0) {
            return;
        }
        Element ele = this.createElement(reg, "RegistryValue");
        ele.setAttribute("Type", "multiString");
        ele.setAttribute("Name", key);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.createElementWithText(ele, "MultiStringValue", value);
            ++n2;
        }
    }

    private void createFeature(Element product) {
        Element feat = this.createElement(product, "Feature");
        feat.setAttribute("Id", "Complete");
        feat.setAttribute("Level", "1");
        feat.setAttribute("Title", this.name);
        feat.setAttribute("Display", "expand");
        feat.setAttribute("Description", "The complete package");
        Element entry = this.createElement(feat, "ComponentGroupRef");
        entry.setAttribute("Id", "ScanComponent");
        for (String comp : this.components) {
            entry = this.createElement(feat, "ComponentRef");
            entry.setAttribute("Id", comp);
        }
    }

    private void createTargetDir(Element product) {
        Element dir1 = this.createElement(product, "Directory");
        dir1.setAttribute("Id", "TARGETDIR");
        dir1.setAttribute("Name", "SourceDir");
        Element dir2 = this.createElement(dir1, "Directory");
        dir2.setAttribute("Name", "PFiles");
        if (this.platform == MsiPlatform.WIN32) {
            dir2.setAttribute("Id", "ProgramFilesFolder");
        } else {
            dir2.setAttribute("Id", "ProgramFiles64Folder");
        }
        Element dir3 = this.createElement(dir2, "Directory");
        dir3.setAttribute("Id", "INSTALLDIR");
        dir3.setAttribute("Name", this.name);
        this.caDir = this.createElement(dir3, "Directory");
        this.caDir.setAttribute("Id", "CA_DIR");
        this.caDir.setAttribute("Name", "configuration");
    }

    private void createUpgrade(Element product) {
        Element ele = this.createElement(product, "MajorUpgrade");
        ele.setAttribute("AllowDowngrades", "yes");
    }

    private void createMedia(Element product) {
        Element ele = this.createElement(product, "Media");
        ele.setAttribute("Id", "1");
        ele.setAttribute("Cabinet", "contents.cab");
        ele.setAttribute("EmbedCab", "yes");
        ele.setAttribute("CompressionLevel", "none");
    }

    private void createPackage(Element product) {
        Element ele = this.createElement(product, "Package");
        ele.setAttribute("InstallScope", "perMachine");
        ele.setAttribute("InstallPrivileges", "elevated");
        ele.setAttribute("InstallerVersion", "200");
        ele.setAttribute("Compressed", "yes");
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getUpgradeCode() {
        return this.upgradeCode;
    }

    public void setUpgradeCode(String upgradeCode) {
        this.upgradeCode = upgradeCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void addCommonDriver(CommonDriverService driver) {
        this.commonDrivers.add(driver);
    }

    public void addApplication(EquinoxAppService equinoxAppService) {
        this.apps.add(equinoxAppService);
    }

    public MsiPlatform getPlatform() {
        return this.platform;
    }

    public void setPlatform(MsiPlatform platform) {
        this.platform = platform;
    }

    public void setLicenseFile(File licenseFile) {
        this.licenseFile = licenseFile;
    }

    public static class CommonDriverService {
        private final String name;
        private final File configuration;
        private final Properties props;

        public CommonDriverService(String name, File configuration, Properties props) {
            this.name = name;
            this.configuration = configuration;
            this.props = props;
        }

        public File getConfiguration() {
            return this.configuration;
        }

        public String getName() {
            return this.name;
        }

        public Properties getProps() {
            return this.props;
        }
    }

    public static class EquinoxAppService {
        private final String name;
        private final Profile profile;
        private final File configurationBase;

        public EquinoxAppService(String name, Profile profile, File configurationBase) {
            this.name = name;
            this.profile = profile;
            this.configurationBase = configurationBase;
        }

        public String getName() {
            return this.name;
        }

        public Profile getProfile() {
            return this.profile;
        }

        public File getConfigurationBase() {
            return this.configurationBase;
        }
    }

    private static class ServiceConfiguration {
        String displayName;
        String description;
        String startClass;
        String startMethod;
        String stopClass;
        String stopMethod;
        String[] startArguments;
        Properties properties;
        String classpath;
        List<String> jvmArgs;

        private ServiceConfiguration() {
        }
    }
}

