/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.internal;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.scada.configuration.world.lib.oscar.OscarProcessor;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends Plugin {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    public static final String PLUGIN_ID = "org.eclipse.scada.configuration.world.lib";
    public static final String EXTP_GENERATOR = "org.eclipse.scada.configuration.world.lib.generator";
    public static final String ELE_OSCAR_PROCESSOR = "oscarProcessor";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Collection<OscarProcessor> createProcessors() {
        LinkedList<OscarProcessor> result = new LinkedList<OscarProcessor>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_GENERATOR);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            if (ele.getName().equals(ELE_OSCAR_PROCESSOR)) {
                try {
                    result.add((OscarProcessor)ele.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    logger.warn("Failed to create oscar processor", (Throwable)e);
                    Activator.getDefault().getLog().log(e.getStatus());
                }
            }
            ++n2;
        }
        return result;
    }

    public static Activator getDefault() {
        return plugin;
    }
}

