/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.util.HashMap;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.world.Application;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.lib.Nodes;
import org.eclipse.scada.configuration.world.lib.oscar.BasicOscarProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.osgi.Connection;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;

public class ConnectionProcessor
extends BasicOscarProcessor {
    private final EquinoxApplication app;

    public ConnectionProcessor(EquinoxApplication app, OscarContext ctx) {
        super((NamedDocumentable)app, ctx);
        this.app = app;
    }

    public void process() {
        for (Connection connection : this.app.getConnections()) {
            this.createConnection(connection);
        }
    }

    private void createConnection(Connection connection) {
        HashMap<String, String> data = new HashMap<String, String>();
        String configurationId = Names.makeName((NamedDocumentable)connection);
        Endpoint ep = connection.getEndpoint();
        boolean isLocal = Nodes.isLocal(ep.getNode(), (Application)this.app);
        data.put("connection.uri", connection.makeUri(isLocal));
        this.addData(String.valueOf(connection.getTypeTag()) + ".connection", configurationId, data);
    }
}

