/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.lib.Properties;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.lib.oscar.BasicOscarProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.osgi.DataMapper;
import org.eclipse.scada.configuration.world.osgi.DataMapperEntry;
import org.eclipse.scada.configuration.world.osgi.JdbcDataMapper;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.SimpleDataMapper;

public class DataMapperProcessor
extends BasicOscarProcessor {
    private final MasterServer app;

    public DataMapperProcessor(MasterServer app, OscarContext ctx) {
        super((NamedDocumentable)app, ctx);
        this.app = app;
    }

    public void process() {
        for (DataMapper dataMapper : this.app.getDataMapper()) {
            if (dataMapper instanceof SimpleDataMapper) {
                this.processSimple((SimpleDataMapper)dataMapper);
                continue;
            }
            if (!(dataMapper instanceof JdbcDataMapper)) continue;
            this.processJdbc((JdbcDataMapper)dataMapper);
        }
    }

    private void processJdbc(JdbcDataMapper dataMapper) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("jdbcDriver", dataMapper.getJdbcDriver());
        data.put("sql", dataMapper.getSql());
        data.putAll(Properties.makeAttributes((String)"properties.", (Collection)dataMapper.getProperties()));
        this.addData("org.eclipse.scada.da.mapper.osgi.jdbcMapper", Names.makeName((NamedDocumentable)dataMapper), data);
    }

    private void processSimple(SimpleDataMapper dataMapper) {
        HashMap<String, String> data = new HashMap<String, String>();
        for (DataMapperEntry entry : dataMapper.getEntries()) {
            data.put("data." + entry.getKey(), entry.getValue());
        }
        this.addData("org.eclipse.scada.da.mapper.osgi.configuredMapper", Names.makeName((NamedDocumentable)dataMapper), data);
    }
}

