/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.scada.ca.oscar.OscarWriter;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.lib.AbstractFolderProcessor;
import org.eclipse.scada.configuration.world.lib.internal.Activator;
import org.eclipse.scada.configuration.world.lib.oscar.ConnectionProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.EventStorageJdbcModuleProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.EventStoragePostgresModuleProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.ExporterProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.JdbcUserServiceModuleProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.OscarProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.P2ProfileProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.sec.SecurityProcessor;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;

public abstract class EquinoxApplicationProcessor
extends AbstractFolderProcessor {
    private final EquinoxApplication app;

    public EquinoxApplicationProcessor(EquinoxApplication app) {
        super((NamedDocumentable)app);
        this.app = app;
    }

    protected Collection<OscarProcessor> createProcessors() {
        LinkedList<OscarProcessor> result = new LinkedList<OscarProcessor>();
        result.addAll(Activator.createProcessors());
        return result;
    }

    @Override
    public void processLocal(IFolder output, IProgressMonitor parentMonitor) throws Exception {
        SubProgressMonitor monitor = new SubProgressMonitor(parentMonitor, 11);
        OscarContext ctx = this.createContext();
        new SecurityProcessor(this.app, ctx).process((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
        new JdbcUserServiceModuleProcessor(this.app, ctx).process((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
        new EventStoragePostgresModuleProcessor(this.app, ctx).process((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
        new EventStorageJdbcModuleProcessor(this.app, ctx).process((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
        new ConnectionProcessor(this.app, ctx).process();
        new ExporterProcessor(this.app, ctx).process();
        Collection<OscarProcessor> processors = this.createProcessors();
        monitor.worked(1);
        SubProgressMonitor subMonitor = new SubProgressMonitor((IProgressMonitor)monitor, 1);
        subMonitor.beginTask("Process application modules", processors.size());
        for (OscarProcessor processor : processors) {
            processor.process(ctx, this.app, (IProgressMonitor)subMonitor);
            subMonitor.worked(1);
        }
        subMonitor.done();
        this.processForContext(ctx, output, (IProgressMonitor)monitor);
        OscarWriter writer = new OscarWriter(ctx.getData(), ctx.getIgnoreFields());
        monitor.worked(1);
        IFile file = output.getFile("configuration.oscar");
        Object object = null;
        Throwable throwable = null;
        try (FileOutputStream fos = new FileOutputStream(file.getRawLocation().toOSString());){
            writer.write((OutputStream)fos);
        }
        catch (Throwable throwable2) {
            if (object == null) {
                object = throwable2;
            } else if (object != throwable2) {
                ((Throwable)object).addSuppressed(throwable2);
            }
            throw object;
        }
        monitor.worked(1);
        IFile jsonFile = output.getFile("data.json");
        throwable = null;
        Object var10_13 = null;
        try (FileOutputStream fos = new FileOutputStream(jsonFile.getRawLocation().toOSString());){
            OscarWriter.writeData(ctx.getData(), (OutputStream)fos);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        monitor.worked(1);
        new P2ProfileProcessor(this.app).process(output.getLocation().toFile(), (IProgressMonitor)monitor);
        monitor.worked(1);
        output.refreshLocal(2, (IProgressMonitor)monitor);
        monitor.done();
    }

    protected abstract void processForContext(OscarContext var1, IFolder var2, IProgressMonitor var3) throws Exception;

    private OscarContext createContext() {
        OscarContext result = new OscarContext();
        this.customizeContext(result);
        return result;
    }

    protected void customizeContext(OscarContext result) {
    }
}

