/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.util.HashMap;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.lib.oscar.BasicOscarProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.Exporter;
import org.eclipse.scada.configuration.world.osgi.profile.Profile;
import org.eclipse.scada.configuration.world.osgi.profile.ProfileFactory;
import org.eclipse.scada.configuration.world.osgi.profile.SystemProperty;

public class ExporterProcessor
extends BasicOscarProcessor {
    private final EquinoxApplication app;

    public ExporterProcessor(EquinoxApplication app, OscarContext ctx) {
        super((NamedDocumentable)app, ctx);
        this.app = app;
    }

    public void process() {
        if (this.app.getCustomizationProfile() == null) {
            this.app.setCustomizationProfile(ProfileFactory.eINSTANCE.createProfile());
        }
        Profile prof = this.app.getCustomizationProfile();
        HashMap countMap = new HashMap();
        for (Exporter exporter : this.app.getExporter()) {
            if (exporter.getEndpoints().size() != 1) {
                throw new IllegalStateException("At the moment each exporter must not have exactly than one endpoint");
            }
            if (countMap.containsKey(exporter.getClass())) {
                throw new IllegalStateException(String.format("At the moment there must not me more than one exporter at a time for the type: %s", exporter.getClass()));
            }
            countMap.put(exporter.getClass(), exporter);
            String tag = exporter.getTypeTag();
            this.put(prof, String.format("org.eclipse.scada.%s.server.exporter.ngp.exportUri", tag), this.makeUri(tag, (Endpoint)exporter.getEndpoints().get(0)));
        }
    }

    private String makeUri(String tag, Endpoint endpoint) {
        return String.format("%s:ngp://0.0.0.0:%s", tag, endpoint.getPortNumber());
    }

    private void put(Profile prof, String key, String value) {
        SystemProperty prop = ProfileFactory.eINSTANCE.createSystemProperty();
        prof.getProperty().add((Object)prop);
        prop.setEval(false);
        prop.setKey(key);
        prop.setValue(value);
    }
}

