/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.scada.configuration.lib.Locator;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.lib.oscar.BasicOscarProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.osgi.DataAccessConnection;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.ValueArchive;
import org.eclipse.scada.configuration.world.osgi.ValueArchiveServer;
import org.eclipse.scada.utils.str.StringHelper;

public class ValueArchiveProcessor
extends BasicOscarProcessor {
    private final ValueArchiveServer app;
    private final IFile commandFile;
    private final StringBuilder commandBuilder = new StringBuilder();
    private static final String NL = System.getProperty("line.separator", "\n");

    public ValueArchiveProcessor(ValueArchiveServer app, OscarContext ctx, IFile commandFile) {
        super((NamedDocumentable)app, ctx);
        this.app = app;
        this.commandFile = commandFile;
    }

    public void process(IProgressMonitor monitor) throws Exception {
        for (ValueArchive archive : this.app.getArchives()) {
            this.createValueArchive(archive);
        }
        this.writeCommandFile(monitor);
    }

    private void writeCommandFile(IProgressMonitor monitor) throws Exception {
        String data = "# These commands must be executed on the target instance" + NL + this.commandBuilder;
        Throwable throwable = null;
        Object var4_5 = null;
        try (ByteArrayInputStream input = new ByteArrayInputStream(data.getBytes());){
            this.commandFile.create((InputStream)input, 2, monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void createValueArchive(ValueArchive archive) {
        EList items = archive.getItems();
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            this.createArchive(archive, this.createSource(archive, (Item)items.get(0), 0));
        } else {
            int i = 1;
            LinkedList<String> sources = new LinkedList<String>();
            for (Item item : items) {
                sources.add(this.createSource(archive, item, i));
                ++i;
            }
            this.createArchive(archive, this.createProxy(archive, sources));
        }
    }

    private String createProxy(ValueArchive archive, List<String> sources) {
        HashMap<String, String> data = new HashMap<String, String>();
        String id = String.valueOf(Names.makeName((NamedDocumentable)archive)) + ".proxy";
        for (String source : sources) {
            if (!source.contains(",")) continue;
            throw new IllegalArgumentException(String.format("Item name '%s' is invalid. Proxy sources must not contain comma (,) in their name.", source));
        }
        Collections.sort(sources);
        data.put("sources", StringHelper.join(sources, (String)", "));
        this.addData("da.datasource.proxy", id, data);
        return id;
    }

    private void createArchive(ValueArchive archive, String sourceId) {
        HashMap<String, String> data = new HashMap<String, String>();
        String id = Names.makeName((NamedDocumentable)archive);
        data.put("datasource.id", sourceId);
        this.addData("historical.item.factory", id, data);
        this.commandBuilder.append(String.format("hds:create %s 3600000 2160", id));
        this.commandBuilder.append(NL);
    }

    private String createSource(ValueArchive archive, Item item, int number) {
        HashMap<String, String> data = new HashMap<String, String>();
        DataAccessConnection connection = this.findConnection(item);
        data.put("item.id", item.getName());
        data.put("connection.id", Names.makeName((NamedDocumentable)connection));
        String id = this.makeId(archive, number, "source");
        this.addData("da.datasource.dataitem", id, data);
        return id;
    }

    private DataAccessConnection findConnection(Item item) {
        return (DataAccessConnection)Locator.findPossibleConnection((EquinoxApplication)this.app, (EquinoxApplication)((EquinoxApplication)item.eContainer()), DataAccessConnection.class);
    }

    public String makeId(ValueArchive archive, int number, String suffix) {
        return String.format("%s/%s.%s", Names.makeName((NamedDocumentable)archive), number, suffix);
    }
}

