/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.utils;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;

public class CopyRecursive
extends SimpleFileVisitor<Path> {
    private final Path source;
    private final Path target;

    public CopyRecursive(Path source, Path target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        Path newdir = this.target.resolve(this.source.relativize(dir));
        try {
            Files.copy(dir, newdir, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        try {
            Files.copy(file, this.target.resolve(this.source.relativize(file)), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        if (exc == null) {
            Path newdir = this.target.resolve(this.source.relativize(dir));
            try {
                Files.setLastModifiedTime(newdir, Files.getLastModifiedTime(dir, new LinkOption[0]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return FileVisitResult.CONTINUE;
    }
}

