/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.deployment.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.scada.configuration.world.Node;
import org.eclipse.scada.configuration.world.deployment.DeploymentPackage;
import org.eclipse.scada.configuration.world.deployment.ExpressionNodeMappingEntry;

public class ExpressionNodeMappingEntryImpl
extends MinimalEObjectImpl.Container
implements ExpressionNodeMappingEntry {
    protected static final Pattern PATTERN_EDEFAULT = null;
    protected Pattern pattern = PATTERN_EDEFAULT;
    protected static final String REPLACEMENT_EDEFAULT = null;
    protected String replacement = REPLACEMENT_EDEFAULT;

    protected ExpressionNodeMappingEntryImpl() {
    }

    protected EClass eStaticClass() {
        return DeploymentPackage.Literals.EXPRESSION_NODE_MAPPING_ENTRY;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public void setPattern(Pattern newPattern) {
        Pattern oldPattern = this.pattern;
        this.pattern = newPattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldPattern, (Object)this.pattern));
        }
    }

    @Override
    public String getReplacement() {
        return this.replacement;
    }

    @Override
    public void setReplacement(String newReplacement) {
        String oldReplacement = this.replacement;
        this.replacement = newReplacement;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldReplacement, (Object)this.replacement));
        }
    }

    @Override
    public boolean mapNode(Node node) {
        if (node == null || node.getHostName() == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(this.getPattern().pattern(), 2);
        Matcher m = pattern.matcher(node.getHostName());
        if (m.matches()) {
            node.setHostName(m.replaceAll(this.replacement));
            return true;
        }
        return false;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getPattern();
            }
            case 1: {
                return this.getReplacement();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setPattern((Pattern)newValue);
                return;
            }
            case 1: {
                this.setReplacement((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setPattern(PATTERN_EDEFAULT);
                return;
            }
            case 1: {
                this.setReplacement(REPLACEMENT_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return PATTERN_EDEFAULT == null ? this.pattern != null : !PATTERN_EDEFAULT.equals(this.pattern);
            }
            case 1: {
                return REPLACEMENT_EDEFAULT == null ? this.replacement != null : !REPLACEMENT_EDEFAULT.equals(this.replacement);
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.mapNode((Node)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (pattern: ");
        result.append(this.pattern);
        result.append(", replacement: ");
        result.append(this.replacement);
        result.append(')');
        return result.toString();
    }
}

