/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.server.common.session;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.scada.core.server.Session;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionImpl
implements Session {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSessionImpl.class);
    private final UserInformation userInformation;
    private final Map<String, String> properties;
    private volatile Set<String> privileges = new HashSet<String>();
    private final Set<Session.SessionListener> listeners = new CopyOnWriteArraySet<Session.SessionListener>();
    private final Set<DisposeListener> disposeListeners = new LinkedHashSet<DisposeListener>();
    private boolean disposed;
    private final Set<SessionCallbackHandler> sessionCallbackHandlers = new HashSet<SessionCallbackHandler>();

    public AbstractSessionImpl(UserInformation userInformation, Map<String, String> properties) {
        this.userInformation = userInformation;
        this.properties = properties != null ? new HashMap<String, String>(properties) : Collections.emptyMap();
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public UserInformation getUserInformation() {
        return this.userInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        HashSet<SessionCallbackHandler> handlers;
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        Set<SessionCallbackHandler> set = this.sessionCallbackHandlers;
        synchronized (set) {
            handlers = new HashSet<SessionCallbackHandler>(this.sessionCallbackHandlers);
            this.sessionCallbackHandlers.clear();
        }
        for (SessionCallbackHandler handler : handlers) {
            handler.dispose();
        }
        for (DisposeListener listener : this.disposeListeners) {
            try {
                listener.disposed();
            }
            catch (Exception e) {
                logger.warn("Failed to handle dispose", (Throwable)e);
            }
        }
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.disposeListeners.add(disposeListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.disposeListeners.remove(disposeListener);
    }

    public void addSessionListener(Session.SessionListener listener) {
        if (this.listeners.add(listener)) {
            listener.privilegeChange();
        }
    }

    public void removeSessionListener(Session.SessionListener listener) {
        this.listeners.remove(listener);
    }

    protected void firePrivilegeChange() {
        for (Session.SessionListener listener : this.listeners) {
            listener.privilegeChange();
        }
    }

    public void setPrivileges(Set<String> privileges) {
        this.privileges = privileges;
        this.firePrivilegeChange();
    }

    public Set<String> getPrivileges() {
        return this.privileges;
    }

    public CallbackHandler wrapCallbackHandler(CallbackHandler callbackHandler) {
        if (callbackHandler == null || this.disposed) {
            return null;
        }
        SessionCallbackHandler sch = new SessionCallbackHandler(callbackHandler);
        this.addCallbackHandler(sch);
        return sch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCallbackHandler(SessionCallbackHandler sessionCallbackHandler) {
        Set<SessionCallbackHandler> set = this.sessionCallbackHandlers;
        synchronized (set) {
            this.sessionCallbackHandlers.add(sessionCallbackHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCallbackHandler(SessionCallbackHandler sessionCallbackHandler) {
        Set<SessionCallbackHandler> set = this.sessionCallbackHandlers;
        synchronized (set) {
            this.sessionCallbackHandlers.remove(sessionCallbackHandler);
        }
    }

    public static interface DisposeListener {
        public void disposed();
    }

    private class SessionCallbackHandler
    implements CallbackHandler {
        private final CallbackHandler callbackHandler;
        private NotifyFuture<Callback[]> future;

        public SessionCallbackHandler(CallbackHandler callbackHandler) {
            this.callbackHandler = callbackHandler;
        }

        public NotifyFuture<Callback[]> performCallback(Callback[] callbacks) {
            this.future = this.callbackHandler.performCallback(callbacks);
            this.future.addListener(new Runnable(){

                @Override
                public void run() {
                    AbstractSessionImpl.this.removeCallbackHandler(SessionCallbackHandler.this);
                }
            });
            return this.future;
        }

        public void dispose() {
            if (this.future != null) {
                this.future.cancel(false);
            }
        }
    }
}

