/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.styles;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;

public class ColorUpdater
implements IPropertyChangeListener {
    private final String name;
    private final ResourceManager manager;
    private final ColorDescriptor defaultColor;
    private ColorDescriptor activeColor;
    private Color color;

    public ColorUpdater(String name, ResourceManager manager, ColorDescriptor defaultColor) {
        this.name = name;
        this.manager = manager;
        this.defaultColor = defaultColor;
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
        this.refresh();
    }

    public void dispose() {
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.name != null && this.name.equals(event.getProperty())) {
            this.refresh();
        }
    }

    private void refresh() {
        if (this.color != null) {
            this.color = null;
        }
        if (this.activeColor != null) {
            this.manager.destroyColor(this.activeColor);
            this.activeColor = null;
        }
        this.activeColor = JFaceResources.getColorRegistry().getColorDescriptor(this.name, this.defaultColor);
        if (this.activeColor != null) {
            this.color = this.manager.createColor(this.activeColor);
        }
    }

    public Color getColor() {
        return this.color;
    }
}

