/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.styles.generator;

import org.eclipse.scada.core.ui.styles.StateInformation;
import org.eclipse.scada.core.ui.styles.StyleGenerator;
import org.eclipse.scada.core.ui.styles.StyleHandler;
import org.eclipse.scada.core.ui.styles.generator.AbstractStyleGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingStyleGenerator
extends AbstractStyleGenerator {
    private static final Logger logger = LoggerFactory.getLogger(DelegatingStyleGenerator.class);
    private StyleGenerator generator;
    private final StyleGenerator.GeneratorListener listener = new StyleGenerator.GeneratorListener(){

        @Override
        public void configurationChanged() {
            DelegatingStyleGenerator.this.handleConfigurationChanged();
        }
    };

    protected void setStyleGenerator(StyleGenerator generator) {
        logger.debug("Set style generator to {}", (Object)generator);
        if (this.generator != null) {
            this.generator.removeListener(this.listener);
            this.generator = null;
        }
        this.generator = generator;
        if (this.generator != null) {
            this.generator.addListener(this.listener);
        }
        this.fireConfigurationChanged();
    }

    protected void handleConfigurationChanged() {
        this.fireConfigurationChanged();
    }

    @Override
    public StyleHandler.Style generateStyle(StateInformation state) {
        if (this.generator == null) {
            return null;
        }
        return this.generator.generateStyle(state);
    }

    @Override
    public void dispose() {
    }
}

