/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.scada.core.Variant;

public class AttributesHelper {
    public static void mergeAttributes(Map<String, Variant> target, Map<String, Variant> change, Map<String, Variant> diff) {
        if (change == null) {
            return;
        }
        for (Map.Entry<String, Variant> entry : change.entrySet()) {
            if (entry.getKey() == null) continue;
            if (entry.getValue() == null) {
                if (!target.containsKey(entry.getKey())) continue;
                target.remove(entry.getKey());
                if (diff == null) continue;
                diff.put(entry.getKey(), null);
                continue;
            }
            if (entry.getValue().isNull()) {
                if (!target.containsKey(entry.getKey())) continue;
                target.remove(entry.getKey());
                if (diff == null) continue;
                diff.put(entry.getKey(), null);
                continue;
            }
            if (diff != null && !target.containsKey(entry.getKey())) {
                diff.put(entry.getKey(), entry.getValue());
            } else if (diff != null && !target.get(entry.getKey()).equals(entry.getValue())) {
                diff.put(entry.getKey(), entry.getValue());
            }
            target.put(entry.getKey(), entry.getValue());
        }
    }

    public static void mergeAttributes(Map<String, Variant> target, Map<String, Variant> change) {
        AttributesHelper.mergeAttributes(target, change, null);
    }

    public static void mergeAttributes(Map<String, Variant> target, Map<String, Variant> diff, boolean initial) {
        if (initial) {
            target.clear();
        }
        AttributesHelper.mergeAttributes(target, diff);
    }

    public static void set(Map<String, Variant> target, Map<String, Variant> attributes, Map<String, Variant> diff) {
        if (attributes == null) {
            attributes = Collections.emptyMap();
        }
        HashSet<String> initialSet = new HashSet<String>(target.keySet());
        for (Map.Entry<String, Variant> entry : attributes.entrySet()) {
            if (target.containsKey(entry.getKey())) {
                if (entry.getValue() == null || entry.getValue().isNull()) {
                    target.remove(entry.getKey());
                    diff.put(entry.getKey(), null);
                } else if (!target.get(entry.getKey()).equals(entry.getValue())) {
                    diff.put(entry.getKey(), entry.getValue());
                    target.put(entry.getKey(), entry.getValue());
                }
                initialSet.remove(entry.getKey());
                continue;
            }
            if (entry.getValue() == null || entry.getValue().isNull()) continue;
            diff.put(entry.getKey(), entry.getValue());
            target.put(entry.getKey(), entry.getValue());
        }
        for (String key : initialSet) {
            target.remove(key);
            diff.put(key, null);
        }
    }

    public static Map<String, Variant> diff(Map<String, Variant> source, Map<String, Variant> target) {
        Map<String, Variant> result = target != null ? new HashMap<String, Variant>(target) : Collections.emptyMap();
        if (source == null) {
            source = Collections.emptyMap();
        }
        HashSet<String> removeSet = new HashSet<String>();
        for (Map.Entry<String, Variant> entry : source.entrySet()) {
            Variant value = (Variant)result.get(entry.getKey());
            if (value == null) {
                result.put(entry.getKey(), null);
                continue;
            }
            if (!value.equals(entry.getValue())) continue;
            removeSet.add(entry.getKey());
        }
        for (String key : removeSet) {
            result.remove(key);
        }
        return result;
    }
}

