/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core;

import java.util.HashMap;
import java.util.Map;

public enum VariantType {
    BOOLEAN(90, Boolean.class),
    INT32(73, Integer.class),
    INT64(74, Long.class),
    DOUBLE(68, Double.class),
    STRING(116, String.class),
    NULL(112, null),
    UNKNOWN(115, Object.class);

    private byte type;
    private Class<?> clazz;
    private static final int approximateNumberOfTypes = 10;
    private static final Map<Byte, VariantType> values;
    private static final Map<Class<?>, VariantType> valuesByClass;

    static {
        values = new HashMap<Byte, VariantType>(10);
        valuesByClass = new HashMap(10);
        VariantType[] variantTypeArray = VariantType.values();
        int n = variantTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariantType t = variantTypeArray[n2];
            values.put(t.toValue(), t);
            valuesByClass.put(t.toJavaType(), t);
            ++n2;
        }
    }

    private VariantType(byte b, Class<?> clazz) {
        this.type = b;
        this.clazz = clazz;
    }

    public static VariantType fromValue(byte value) {
        return values.get(value);
    }

    public static VariantType fromJavaType(Class<?> clazz) {
        return valuesByClass.get(clazz);
    }

    public static VariantType fromJavaObject(Object object) {
        return object == null ? NULL : VariantType.fromJavaType(object.getClass());
    }

    public byte toValue() {
        return this.type;
    }

    public Class<? extends Object> toJavaType() {
        return this.clazz;
    }
}

