/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.ds;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.datasource.ds.DataStoreSourceFactory;
import org.eclipse.scada.ds.DataNodeTracker;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private ExecutorService executor;
    private DataStoreSourceFactory factory;
    private DataNodeTracker dataNodeTracker;

    public void start(BundleContext context) throws Exception {
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(context.getBundle().getSymbolicName()));
        this.dataNodeTracker = new DataNodeTracker(context);
        this.factory = new DataStoreSourceFactory(context, this.executor, this.dataNodeTracker);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.description", "A data store data source");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("factoryId", context.getBundle().getSymbolicName());
        context.registerService(ConfigurationFactory.class.getName(), (Object)this.factory, properties);
        this.dataNodeTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.factory.dispose();
        this.executor.shutdown();
        this.dataNodeTracker.close();
    }
}

