/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource;

import java.util.Dictionary;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.eclipse.scada.utils.osgi.pool.SingleObjectPoolServiceTracker;
import org.osgi.framework.InvalidSyntaxException;

public class SingleDataSourceTracker {
    private final SingleObjectPoolServiceTracker<DataSource> tracker;
    private final ServiceListener listener;

    public SingleDataSourceTracker(ObjectPoolTracker<DataSource> poolTracker, String dataSourceId, ServiceListener listener) throws InvalidSyntaxException {
        this.listener = listener;
        if (listener == null) {
            throw new NullPointerException("'listener' must not be null");
        }
        this.tracker = new SingleObjectPoolServiceTracker(poolTracker, dataSourceId, (SingleObjectPoolServiceTracker.ServiceListener)new SingleObjectPoolServiceTracker.ServiceListener<DataSource>(){

            public void serviceChange(DataSource service, Dictionary<?, ?> properties) {
                SingleDataSourceTracker.this.setDataSource(service);
            }
        });
    }

    protected void setDataSource(DataSource service) {
        this.listener.dataSourceChanged(service);
    }

    public void open() {
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    public static interface ServiceListener {
        public void dataSourceChanged(DataSource var1);
    }
}

