/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.protocol.ngp.codec;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.data.ErrorInformation;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.da.data.AttributeWriteResultEntry;
import org.eclipse.scada.da.data.BrowserEntry;
import org.eclipse.scada.da.data.FolderEntryType;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.protocol.ngp.common.utils.ArrayListAllocator;
import org.eclipse.scada.protocol.ngp.common.utils.CollectionAllocator;
import org.eclipse.scada.protocol.ngp.common.utils.HashSetAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Structures {
    private static final Logger logger = LoggerFactory.getLogger(Structures.class);
    private static final ArrayListAllocator<AttributeWriteResultEntry> ALLOC_ATTRIBUTEWRITERESULTENTRY_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<AttributeWriteResultEntry> ALLOC_ATTRIBUTEWRITERESULTENTRY_SET = new HashSetAllocator();
    private static final ArrayListAllocator<BrowserEntry> ALLOC_BROWSERENTRY_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<BrowserEntry> ALLOC_BROWSERENTRY_SET = new HashSetAllocator();

    private Structures() {
    }

    protected static void inlineEncodeAttributeWriteResultEntry(BinaryContext context, IoBuffer data, AttributeWriteResultEntry value) throws Exception {
        data.put((byte)2);
        context.encodeString(data, (byte)1, value.getAttribute());
        org.eclipse.scada.core.protocol.ngp.codec.Structures.encodeErrorInformation((BinaryContext)context, (IoBuffer)data, (byte)2, (ErrorInformation)value.getErrorInformation());
    }

    protected static AttributeWriteResultEntry inlindeDecodeAttributeWriteResultEntry(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        String attribute = null;
        ErrorInformation errorInformation = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    attribute = _context.decodeString(_data);
                    break;
                }
                case 2: {
                    errorInformation = org.eclipse.scada.core.protocol.ngp.codec.Structures.decodeErrorInformation((BinaryContext)_context, (IoBuffer)_data, (boolean)true);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new AttributeWriteResultEntry(attribute, errorInformation);
    }

    public static void encodeAttributeWriteResultEntry(BinaryContext context, IoBuffer data, byte fieldNumber, AttributeWriteResultEntry value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeAttributeWriteResultEntry(context, data, value);
        }
    }

    public static void encodeCollectionAttributeWriteResultEntry(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<AttributeWriteResultEntry> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (AttributeWriteResultEntry entry : values) {
            Structures.inlineEncodeAttributeWriteResultEntry(context, data, entry);
        }
    }

    public static AttributeWriteResultEntry decodeAttributeWriteResultEntry(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeAttributeWriteResultEntry(context, data);
    }

    protected static void fillAttributeWriteResultEntryCollection(BinaryContext context, IoBuffer data, int items, Collection<AttributeWriteResultEntry> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeAttributeWriteResultEntry(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<AttributeWriteResultEntry>> T decodeAttributeWriteResultEntryCollection(BinaryContext context, IoBuffer data, CollectionAllocator<AttributeWriteResultEntry, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillAttributeWriteResultEntryCollection(context, data, len, result);
        return (T)result;
    }

    public static List<AttributeWriteResultEntry> decodeListAttributeWriteResultEntry(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeAttributeWriteResultEntryCollection(context, data, ALLOC_ATTRIBUTEWRITERESULTENTRY_LIST, allowNull);
    }

    public static Set<AttributeWriteResultEntry> decodeSetAttributeWriteResultEntry(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeAttributeWriteResultEntryCollection(context, data, ALLOC_ATTRIBUTEWRITERESULTENTRY_SET, allowNull);
    }

    protected static void inlineEncodeBrowserEntry(BinaryContext context, IoBuffer data, BrowserEntry value) throws Exception {
        data.put((byte)5);
        context.encodeString(data, (byte)1, value.getName());
        context.encodeEnum(data, (byte)2, (Enum)value.getEntryType());
        context.encodeString(data, (byte)3, value.getItemId());
        context.encodeVariantMap(data, (byte)4, value.getAttributes());
        context.encodeEnumSet(data, (byte)5, value.getIoDirection());
    }

    protected static BrowserEntry inlindeDecodeBrowserEntry(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        String name = null;
        FolderEntryType entryType = null;
        String itemId = null;
        Map attributes = null;
        Set ioDirection = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    name = _context.decodeString(_data);
                    break;
                }
                case 2: {
                    entryType = (FolderEntryType)_context.decodeEnum(_data, FolderEntryType.class);
                    break;
                }
                case 3: {
                    itemId = _context.decodeString(_data);
                    break;
                }
                case 4: {
                    attributes = _context.decodeVariantMap(_data);
                    break;
                }
                case 5: {
                    ioDirection = _context.decodeEnumSet(_data, IODirection.class);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new BrowserEntry(name, entryType, itemId, attributes, ioDirection);
    }

    public static void encodeBrowserEntry(BinaryContext context, IoBuffer data, byte fieldNumber, BrowserEntry value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeBrowserEntry(context, data, value);
        }
    }

    public static void encodeCollectionBrowserEntry(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<BrowserEntry> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (BrowserEntry entry : values) {
            Structures.inlineEncodeBrowserEntry(context, data, entry);
        }
    }

    public static BrowserEntry decodeBrowserEntry(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeBrowserEntry(context, data);
    }

    protected static void fillBrowserEntryCollection(BinaryContext context, IoBuffer data, int items, Collection<BrowserEntry> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeBrowserEntry(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<BrowserEntry>> T decodeBrowserEntryCollection(BinaryContext context, IoBuffer data, CollectionAllocator<BrowserEntry, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillBrowserEntryCollection(context, data, len, result);
        return (T)result;
    }

    public static List<BrowserEntry> decodeListBrowserEntry(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeBrowserEntryCollection(context, data, ALLOC_BROWSERENTRY_LIST, allowNull);
    }

    public static Set<BrowserEntry> decodeSetBrowserEntry(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeBrowserEntryCollection(context, data, ALLOC_BROWSERENTRY_SET, allowNull);
    }
}

