/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.exporter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.exporter.AbstractObjectExporter;
import org.eclipse.scada.da.server.common.item.factory.ItemFactory;

public class StaticObjectExporter<T>
extends AbstractObjectExporter {
    private T target;
    private HashMap<String, Variant> additionalAttributes;

    public StaticObjectExporter(ItemFactory itemFactory, Class<T> modelClazz, boolean readOnly, boolean nullIsError, String prefix) {
        super(itemFactory, readOnly, nullIsError, prefix);
        this.createDataItems(modelClazz);
    }

    public StaticObjectExporter(ItemFactory itemFactory, Class<T> modelClazz, boolean readOnly, boolean nullIsError) {
        this(itemFactory, modelClazz, readOnly, nullIsError, null);
    }

    public synchronized void setTarget(T target, Map<String, Variant> attributes) {
        this.target = target;
        this.applyAttributes(attributes);
        this.updateItemsFromTarget();
    }

    public synchronized void setTarget(T target) {
        this.target = target;
        this.updateItemsFromTarget();
    }

    public synchronized void setAttributes(Map<String, Variant> attributes) {
        this.applyAttributes(attributes);
        this.updateItemsFromTarget();
    }

    private void applyAttributes(Map<String, Variant> attributes) {
        this.additionalAttributes = attributes == null ? null : new HashMap<String, Variant>(attributes);
    }

    @Override
    protected Map<String, Variant> getAdditionalAttributes() {
        if (this.additionalAttributes == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.additionalAttributes);
    }

    @Override
    protected Object getTarget() {
        return this.target;
    }
}

