/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.modbus;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.SimpleIoProcessorPool;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSession;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.exporter.common.HiveSource;
import org.eclipse.scada.da.server.exporter.common.ServiceListenerHiveSource;
import org.eclipse.scada.da.server.exporter.modbus.ModbusExport;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.concurrent.ScheduledExportedExecutorService;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExporterFactoryImpl
extends AbstractServiceConfigurationFactory<ModbusExport> {
    private static final Logger logger = LoggerFactory.getLogger(ExporterFactoryImpl.class);
    private final ScheduledExportedExecutorService executor = new ScheduledExportedExecutorService(FrameworkUtil.getBundle(ExporterFactoryImpl.class).getSymbolicName(), 1);
    private final ServiceListenerHiveSource hiveSource;
    private final IoProcessor<NioSession> processor = new SimpleIoProcessorPool(NioProcessor.class);
    private final ObjectPoolImpl<DataItem> itemPool;
    private final ServiceRegistration<?> itemPoolHandler;

    public ExporterFactoryImpl() {
        super(FrameworkUtil.getBundle(ExporterFactoryImpl.class).getBundleContext());
        this.hiveSource = new ServiceListenerHiveSource(FrameworkUtil.getBundle(ExporterFactoryImpl.class).getBundleContext(), (Executor)this.executor);
        this.hiveSource.open();
        this.itemPool = new ObjectPoolImpl();
        this.itemPoolHandler = ObjectPoolHelper.registerObjectPool((BundleContext)FrameworkUtil.getBundle(ExporterFactoryImpl.class).getBundleContext(), this.itemPool, DataItem.class);
    }

    public void dispose() {
        logger.info("Disposing");
        this.itemPoolHandler.unregister();
        super.dispose();
        this.itemPool.dispose();
        this.processor.dispose();
        this.hiveSource.close();
        this.executor.shutdown();
    }

    protected AbstractServiceConfigurationFactory.Entry<ModbusExport> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        ModbusExport service = new ModbusExport(configurationId, (ScheduledExecutorService)this.executor, this.processor, (HiveSource)this.hiveSource, (ManageableObjectPool<DataItem>)this.itemPool);
        service.update(parameters);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)service);
    }

    protected void disposeService(UserInformation userInformation, String configurationId, ModbusExport service) {
        service.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<ModbusExport> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<ModbusExport> entry, Map<String, String> parameters) throws Exception {
        ((ModbusExport)entry.getService()).update(parameters);
        return null;
    }
}

