/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.modbus.io;

import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.exporter.modbus.io.AbstractSourceType;

public class ShortType
extends AbstractSourceType {
    private final Double factor;
    private static final int DATA_LENGTH = 2;
    public static final int LENGTH = 12;

    public ShortType(Double factor) {
        super(2);
        this.factor = factor;
    }

    public ShortType() {
        this(null);
    }

    @Override
    public void putValue(IoBuffer slice, Variant value) {
        slice.putShort(this.makeValue(value));
    }

    private short makeValue(Variant value) {
        if (value == null) {
            return 0;
        }
        if (this.factor == null) {
            Integer v = value.asInteger(null);
            if (v == null) {
                return 0;
            }
            return v.shortValue();
        }
        Double v = value.asDouble(null);
        if (v == null) {
            return 0;
        }
        return (short)(this.factor * v);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.factor == null ? 0 : this.factor.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShortType)) {
            return false;
        }
        ShortType other = (ShortType)obj;
        return !(this.factor == null ? other.factor != null : !this.factor.equals(other.factor));
    }
}

