/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.widgets.realtime;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scada.da.ui.widgets.realtime.AttributePair;
import org.eclipse.scada.da.ui.widgets.realtime.ListEntry;

public class ItemCellLabelProvider
extends CellLabelProvider {
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public void update(ViewerCell cell) {
        Object o = cell.getElement();
        if (o instanceof ListEntry) {
            this.updateListEntry((ListEntry)o, cell);
        } else if (o instanceof AttributePair) {
            this.updateAttributePair((AttributePair)o, cell);
        }
    }

    private void updateAttributePair(AttributePair attributePair, ViewerCell cell) {
        switch (cell.getColumnIndex()) {
            case 0: {
                cell.setText(attributePair.key);
                break;
            }
            case 2: {
                if (attributePair.value == null) break;
                cell.setText(attributePair.value.getType().name());
                break;
            }
            case 3: {
                if (attributePair.value == null) break;
                cell.setText(attributePair.value.asString("<null>"));
                break;
            }
        }
    }

    private void updateListEntry(ListEntry listEntry, ViewerCell cell) {
        cell.setFont(listEntry.getFont());
        cell.setForeground(listEntry.getForeground());
        cell.setBackground(listEntry.getBackground());
        switch (cell.getColumnIndex()) {
            case 0: {
                cell.setImage(listEntry.getImage());
                cell.setText(listEntry.getDataItem().getItem().getId());
                break;
            }
            case 1: {
                if (listEntry.getSubscriptionError() != null) {
                    cell.setText(String.format("%s (%s)", listEntry.getSubscriptionState(), listEntry.getSubscriptionError().getMessage()));
                    break;
                }
                cell.setText(listEntry.getSubscriptionState().name());
                break;
            }
            case 2: {
                if (listEntry.getValue() == null) break;
                cell.setText(listEntry.getValue().getType().name());
                break;
            }
            case 3: {
                if (listEntry.getValue() == null) break;
                cell.setText(listEntry.getValue().asString("<null>"));
                break;
            }
        }
    }

    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }
}

