/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.utils.daemon;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.commons.daemon.DaemonController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonStarter
implements DaemonController {
    private static final Logger logger = LoggerFactory.getLogger(DaemonStarter.class);
    private final Daemon daemon;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            throw new RuntimeException("syntax: DaemonStarter <daemon class name>");
        }
        LinkedList<String> argList = new LinkedList<String>();
        argList.addAll(Arrays.asList(args));
        new DaemonStarter(Class.forName((String)argList.poll()), argList.toArray(new String[0]));
        while (true) {
            Thread.sleep(1000L);
        }
    }

    public DaemonStarter(Class<?> className, final String[] args) throws Exception {
        Object o = className.newInstance();
        if (!(o instanceof Daemon)) {
            throw new RuntimeException(String.format("Class must implement '%s'", Daemon.class));
        }
        final DaemonStarter controller = this;
        this.daemon = (Daemon)o;
        this.daemon.init(new DaemonContext(){

            public String[] getArguments() {
                return args;
            }

            public DaemonController getController() {
                return controller;
            }
        });
        this.daemon.start();
    }

    public void fail() throws IllegalStateException {
        logger.error("Service failed");
        System.exit(-1);
    }

    public void fail(String arg0) throws IllegalStateException {
        logger.error("Service failed: " + arg0);
        System.exit(-1);
    }

    public void fail(Exception arg0) throws IllegalStateException {
        logger.error("Service failed", (Throwable)arg0);
    }

    public void fail(String arg0, Exception arg1) throws IllegalStateException {
        logger.error(String.format("Service failed: '%s'", arg0), (Throwable)arg1);
    }

    public void reload() throws IllegalStateException {
        try {
            this.daemon.stop();
            this.daemon.start();
        }
        catch (Exception e) {
            this.fail("Failed to reload", e);
        }
    }

    public void shutdown() throws IllegalStateException {
        if (this.daemon != null) {
            try {
                this.daemon.stop();
            }
            catch (Exception e) {
                this.fail("Failed to shut down", e);
            }
        }
        System.exit(0);
    }
}

