/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ds.storage.jdbc.internal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.eclipse.scada.ds.DataNode;
import org.eclipse.scada.ds.storage.jdbc.internal.JdbcStorageDao;
import org.eclipse.scada.utils.osgi.jdbc.CommonConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.pool.PoolConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.task.CommonConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionContext;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.RowCallback;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStorageDaoBase64Impl
implements JdbcStorageDao {
    private static final Logger logger = LoggerFactory.getLogger(JdbcStorageDaoBase64Impl.class);
    private final String instanceId = System.getProperty("org.eclipse.scada.ds.storage.jdbc.instance", "default");
    private int chunkSize = Integer.getInteger("org.eclipse.scada.ds.storage.jdbc.chunkSize", 0);
    private static final String TABLE_NAME = System.getProperty("org.eclipse.scada.ds.storage.jdbc.table", "datastore");
    private static final String SQL_INSERT = String.format("insert into %s ( node_id, instance_id, sequence_nr, data ) values ( ?, ?, ?, ? )", TABLE_NAME);
    private static final String SQL_SELECT = String.format("select data from %s where node_id=? and instance_id=? order by sequence_nr", TABLE_NAME);
    private static final String SQL_SELECT_ALL = String.format("select node_id,data from %s where instance_id=? order by sequence_nr", TABLE_NAME);
    private static final String SQL_DELETE = String.format("delete from %s where node_id=? and instance_id=?", TABLE_NAME);
    private final CommonConnectionAccessor accessor;

    public JdbcStorageDaoBase64Impl(DataSourceFactory dataSourceFactory, Properties paramProperties, boolean usePool) throws SQLException {
        Object object = this.accessor = usePool ? new PoolConnectionAccessor(dataSourceFactory, paramProperties) : new DataSourceConnectionAccessor(dataSourceFactory, paramProperties);
        if (this.chunkSize <= 0) {
            this.chunkSize = Integer.MAX_VALUE;
        }
    }

    @Override
    public void dispose() {
        this.accessor.dispose();
    }

    @Override
    public DataNode readNode(String nodeId) {
        List<String> result = this.findAllNode(nodeId);
        if (result.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String entry : result) {
            sb.append(entry);
        }
        String data = sb.toString();
        logger.debug("Read: {}", (Object)data);
        return new DataNode(nodeId, Base64.decodeBase64((String)data));
    }

    @Override
    public Collection<DataNode> readAllNodes() {
        logger.info("Read all nodes");
        return ((AllProcessor)this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<AllProcessor>(){

            protected AllProcessor performTask(ConnectionContext connectionContext) throws SQLException {
                AllProcessor result = new AllProcessor(new LinkedList<DataNode>());
                connectionContext.query((RowCallback)result, SQL_SELECT_ALL, new Object[]{JdbcStorageDaoBase64Impl.this.instanceId});
                return result;
            }
        })).getResult();
    }

    private List<String> findAllNode(final String nodeId) {
        logger.debug("Find node: {}", (Object)nodeId);
        return (List)this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<List<String>>(){

            protected List<String> performTask(ConnectionContext connectionContext) throws SQLException {
                return connectionContext.queryForList(String.class, SQL_SELECT, new Object[]{nodeId, JdbcStorageDaoBase64Impl.this.instanceId});
            }
        });
    }

    protected void deleteNode(ConnectionContext context, String nodeId) throws SQLException {
        context.update(SQL_DELETE, new Object[]{nodeId, this.instanceId});
    }

    @Override
    public void deleteNode(final String nodeId) {
        this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Void>(){

            protected Void performTask(ConnectionContext connectionContext) throws Exception {
                connectionContext.setAutoCommit(false);
                JdbcStorageDaoBase64Impl.this.deleteNode(connectionContext, nodeId);
                connectionContext.commit();
                return null;
            }
        });
    }

    @Override
    public void writeNode(final DataNode node) {
        final String data = node != null && node.getData() != null ? StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])node.getData(), (boolean)true)) : null;
        logger.debug("Write data node: {} -> {}", (Object)node, data);
        this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Void>(){

            protected Void performTask(ConnectionContext connectionContext) throws Exception {
                connectionContext.setAutoCommit(false);
                JdbcStorageDaoBase64Impl.this.deleteNode(connectionContext, node.getId());
                JdbcStorageDaoBase64Impl.this.insertNode(connectionContext, node, data);
                connectionContext.commit();
                return null;
            }
        });
    }

    protected void insertNode(ConnectionContext connectionContext, DataNode node, String data) throws SQLException {
        if (data == null) {
            return;
        }
        PreparedStatement stmt = connectionContext.getConnection().prepareStatement(SQL_INSERT);
        int len = data.length();
        int i = 0;
        while (i <= len / this.chunkSize) {
            int end = (i + 1) * this.chunkSize;
            if (end > len) {
                end = len;
            }
            String chunk = data.substring(i * this.chunkSize, end);
            stmt.setObject(1, node.getId());
            stmt.setObject(2, this.instanceId);
            stmt.setObject(3, i);
            stmt.setObject(4, chunk);
            stmt.addBatch();
            ++i;
        }
        stmt.executeBatch();
    }

    public static class AllProcessor
    implements RowCallback {
        private final Collection<DataNode> result;
        private String currentNodeId;
        private StringBuilder dataBuilder = new StringBuilder();

        public AllProcessor(Collection<DataNode> result) {
            this.result = result;
        }

        public Collection<DataNode> getResult() {
            return this.result;
        }

        public void processRow(ResultSet resultSet) throws SQLException {
            String nodeId = resultSet.getString(1);
            String data = resultSet.getString(2);
            if (nodeId == null) {
                this.currentNodeId = null;
                return;
            }
            if (this.currentNodeId == null || nodeId.equals(this.currentNodeId)) {
                this.dataBuilder.append(data);
            } else {
                this.appendCurrent();
                this.dataBuilder = new StringBuilder(data);
            }
            this.currentNodeId = nodeId;
        }

        public void finish() {
            if (this.dataBuilder.length() > 0) {
                this.appendCurrent();
            }
        }

        private void appendCurrent() {
            this.result.add(new DataNode(this.currentNodeId, Base64.decodeBase64((String)this.dataBuilder.toString())));
        }
    }
}

