/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.osgi;

import org.eclipse.scada.sec.AuthorizationReply;
import org.eclipse.scada.sec.AuthorizationRequest;
import org.eclipse.scada.sec.audit.AuditLogService;
import org.eclipse.scada.sec.authz.AuthorizationContext;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackingAuditLogImplementation
implements AuditLogService {
    private static final Logger logger = LoggerFactory.getLogger(TrackingAuditLogImplementation.class);
    private final SingleServiceTracker<AuditLogService> tracker;
    private volatile AuditLogService service;
    private final SingleServiceListener<AuditLogService> listener = new SingleServiceListener<AuditLogService>(){

        public void serviceChange(ServiceReference<AuditLogService> reference, AuditLogService service) {
            TrackingAuditLogImplementation.this.setService(service);
        }
    };

    public TrackingAuditLogImplementation(BundleContext context) {
        this.tracker = new SingleServiceTracker(context, AuditLogService.class, this.listener);
    }

    protected void setService(AuditLogService service) {
        logger.info("Setting audit log service: {}", (Object)service);
        this.service = service;
    }

    public void open() {
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    public void info(String message, Object ... arguments) {
        this.checkService().info(message, arguments);
    }

    public void debug(String message, Object ... arguments) {
        this.checkService().debug(message, arguments);
    }

    public void info(String message, Throwable e, Object ... arguments) {
        this.checkService().info(message, e, arguments);
    }

    public void debug(String message, Throwable e, Object ... arguments) {
        this.checkService().debug(message, e, arguments);
    }

    public void authorizationRequested(AuthorizationRequest request) {
        this.checkService().authorizationRequested(request);
    }

    public void authorizationFailed(AuthorizationContext context, AuthorizationRequest request, Throwable error) {
        this.checkService().authorizationFailed(context, request, error);
    }

    public void authorizationDone(AuthorizationContext context, AuthorizationRequest request, AuthorizationReply reply) {
        this.checkService().authorizationDone(context, request, reply);
    }

    protected AuditLogService checkService() {
        AuditLogService service = this.service;
        if (service != null) {
            return service;
        }
        throw new IllegalStateException(String.format("No audit log service found", new Object[0]));
    }
}

