/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.input;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.chart.swt.render.AbstractLineRender;
import org.eclipse.scada.ui.chart.viewer.input.AbstractInput;
import org.eclipse.scada.ui.chart.viewer.input.LinePropertiesSupporter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public abstract class LineInput
extends AbstractInput
implements LinePropertiesSupporter {
    private final LocalResourceManager resourceManager;
    private Color lineColor;
    private final Map<Point, Image> previews = new HashMap<Point, Image>();

    public LineInput(ResourceManager resourceManager) {
        this.resourceManager = new LocalResourceManager(resourceManager);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.resourceManager.dispose();
        this.disposePreviews();
    }

    protected abstract AbstractLineRender getLineRenderer();

    @Override
    public void setVisible(boolean visible) {
        AbstractLineRender renderer = this.getLineRenderer();
        if (renderer != null) {
            renderer.setVisible(visible);
        }
        super.setVisible(visible);
    }

    @Override
    public void setLineColor(RGB rgb) {
        if (this.lineColor != null) {
            this.resourceManager.destroyColor(this.lineColor.getRGB());
            this.lineColor = null;
        }
        if (rgb != null) {
            this.lineColor = this.resourceManager.createColor(rgb);
            this.getLineRenderer().setLineColor(this.lineColor);
        }
        this.fireUpdatePreviews();
    }

    @Override
    public RGB getLineColor() {
        if (this.lineColor == null) {
            return null;
        }
        if (this.lineColor.isDisposed()) {
            return null;
        }
        return this.lineColor.getRGB();
    }

    @Override
    public void setLineWidth(float width) {
        this.getLineRenderer().setLineWidth(width);
        this.fireUpdatePreviews();
    }

    @Override
    public float getLineWidth() {
        return this.getLineRenderer().getLineWidth();
    }

    @Override
    protected void fireUpdatePreviews() {
        this.disposePreviews();
        super.fireUpdatePreviews();
    }

    private void disposePreviews() {
        for (Image image : this.previews.values()) {
            image.dispose();
        }
        this.previews.clear();
    }

    @Override
    public Image getPreview(int width, int height) {
        Point p = new Point(width, height);
        Image img = this.previews.get(p);
        if (img == null) {
            Image newImage = LineInput.makePreview(Display.getDefault(), this.getLineRenderer().getLineAttributes(), this.getLineRenderer().getLineColor(), p);
            this.previews.put(p, newImage);
            return newImage;
        }
        return img;
    }

    public static Image makePreview(Display display, LineAttributes lineAttributes, Color lineColor, Point p) {
        Image img = new Image((Device)display, p.x, p.y);
        GC gc = new GC((Drawable)img);
        try {
            gc.setForeground(img.getDevice().getSystemColor(1));
            gc.setBackground(img.getDevice().getSystemColor(1));
            gc.fillRectangle(0, 0, p.x, p.y);
            gc.setLineAttributes(lineAttributes);
            if (lineColor != null) {
                gc.setForeground(lineColor);
            }
            gc.drawLine(0, p.y / 2, p.x, p.y / 2);
        }
        finally {
            gc.dispose();
        }
        return img;
    }
}

