/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.osgi.jdbc.data;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.eclipse.scada.utils.osgi.jdbc.data.RowMapper;
import org.eclipse.scada.utils.osgi.jdbc.data.RowMapperMappingException;
import org.eclipse.scada.utils.osgi.jdbc.data.RowMapperValidationException;

public class SingleColumnRowMapper<T>
implements RowMapper<T> {
    private final Class<T> clazz;

    public SingleColumnRowMapper(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public void validate(ResultSet resultSet) throws RowMapperValidationException, SQLException {
        ResultSetMetaData md = resultSet.getMetaData();
        if (md.getColumnCount() != 1) {
            throw new RowMapperValidationException("Column count must be exactly one");
        }
    }

    @Override
    public T mapRow(ResultSet resultSet) throws RowMapperMappingException, SQLException {
        Object result = resultSet.getObject(1);
        if (this.clazz.isAssignableFrom(result.getClass())) {
            return this.clazz.cast(result);
        }
        throw new RowMapperMappingException(String.format("Failed to map from data type %s to %s", result.getClass(), this.clazz));
    }

    @Override
    public T nullObject() {
        return null;
    }
}

