/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.stats;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scada.utils.stats.StatisticEntry;
import org.eclipse.scada.utils.stats.StatisticValue;

public class StatisticEntryImpl
implements StatisticEntry {
    private volatile String label;
    private final Object key;
    private final AtomicReference<StatisticValue> value = new AtomicReference();

    public StatisticEntryImpl(Object key) {
        this.key = key;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public StatisticValue getValue() {
        return this.value.get();
    }

    public void setCurrentValue(Object key, double number) {
        Number newMax;
        Number newMin;
        StatisticValue newValue;
        StatisticValue current;
        do {
            if ((current = this.value.get()) != null) {
                newMin = StatisticEntryImpl.min(current.getMinimum(), number);
                newMax = StatisticEntryImpl.max(current.getMaximum(), number);
                continue;
            }
            newMax = newMin = Double.valueOf(number);
        } while (!this.value.compareAndSet(current, newValue = new StatisticValue(newMin, newMax, number)));
    }

    public void changeCurrentValue(Object key, double offset) {
        Double number;
        Number newMax;
        Number newMin;
        StatisticValue newValue;
        StatisticValue current;
        do {
            number = (current = this.value.get()) == null || current.getCurrent() == null ? Double.valueOf(offset) : Double.valueOf(current.getCurrent().doubleValue() + offset);
            if (current != null) {
                newMin = StatisticEntryImpl.min(current.getMinimum(), number);
                newMax = StatisticEntryImpl.max(current.getMaximum(), number);
                continue;
            }
            newMax = newMin = number;
        } while (!this.value.compareAndSet(current, newValue = new StatisticValue(newMin, newMax, number)));
    }

    private static Number min(Number n1, Number n2) {
        if (n1 == null) {
            return n2;
        }
        if (n2 == null) {
            return n1;
        }
        return Math.min(n1.doubleValue(), n2.doubleValue());
    }

    private static Number max(Number n1, Number n2) {
        if (n1 == null) {
            return n2;
        }
        if (n2 == null) {
            return n1;
        }
        return Math.max(n1.doubleValue(), n2.doubleValue());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatisticEntryImpl other = (StatisticEntryImpl)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }
}

