/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.impl.visibility;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.scada.vi.data.SummaryProvider;
import org.eclipse.scada.vi.details.swt.impl.visibility.VisibilityProvider;
import org.eclipse.scada.vi.details.swt.impl.visibility.VisibleComponent;

public class ComponentVisibility {
    private final VisibilityProvider provider;
    private final VisibilityProvider.Listener listener;
    private boolean state = true;
    private final VisibleComponent component;
    private final WritableSet descriptors = new WritableSet();
    private final IObservableSet componentDescriptors;
    private final ISetChangeListener setListener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            ComponentVisibility.this.handleSetChange(event.diff);
        }
    };

    public ComponentVisibility(VisibilityProvider provider, VisibleComponent component) {
        this.provider = provider;
        this.component = component;
        this.componentDescriptors = component.getDescriptors();
        component.create();
        this.attachDescriptors();
        this.listener = new VisibilityProvider.Listener(){

            @Override
            public void visibilityChanged(boolean state) {
                ComponentVisibility.this.handleVisibilityChanged(state);
            }
        };
        this.provider.addListener(this.listener);
    }

    public SummaryProvider getSummaryProvider() {
        return this.component.getSummaryProvider();
    }

    protected void handleSetChange(SetDiff diff) {
        diff.applyTo((Set)this.descriptors);
    }

    protected void handleVisibilityChanged(boolean state) {
        if (this.state == state) {
            return;
        }
        this.state = state;
        if (state) {
            this.show();
        } else {
            this.hide();
        }
    }

    protected void hide() {
        this.component.hide();
        this.component.stop();
        this.detachDescriptors();
    }

    protected void show() {
        this.component.start();
        this.component.show();
        this.attachDescriptors();
    }

    private void attachDescriptors() {
        this.componentDescriptors.addSetChangeListener(this.setListener);
        this.descriptors.addAll((Collection)this.componentDescriptors);
    }

    private void detachDescriptors() {
        this.componentDescriptors.removeSetChangeListener(this.setListener);
        this.descriptors.clear();
    }

    public void dispose() {
        this.provider.dispose();
        this.component.dispose();
    }

    public IObservableSet getDescriptors() {
        return this.descriptors;
    }

    public void start() {
        if (this.state) {
            this.component.start();
        }
    }

    public void stop() {
        this.component.stop();
    }
}

