/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.chart.draw2d;

import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class Draw2DGraphics
implements Graphics {
    private final org.eclipse.draw2d.Graphics g;

    public Draw2DGraphics(org.eclipse.draw2d.Graphics g) {
        this.g = g;
    }

    public void setAlpha(int alpha) {
        this.g.setAlpha(alpha);
    }

    public void setLineAttributes(LineAttributes lineAttributes) {
        this.g.setLineAttributes(lineAttributes);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g.drawLine(x1, y1, x2, y2);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.g.fillRectangle(x, y, width, height);
    }

    public Color getSystemColor(int color) {
        return Display.getCurrent().getSystemColor(color);
    }

    public void setForeground(Color color) {
        this.g.setForegroundColor(color);
    }

    public void setBackground(Color color) {
        this.g.setBackgroundColor(color);
    }

    public void setClipping(Rectangle rect) {
        this.g.setClip(new org.eclipse.draw2d.geometry.Rectangle(rect.x, rect.y, rect.width, rect.height));
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.g.drawRectangle(x, y, width, height);
    }

    public void drawRectangle(Rectangle rect) {
        this.g.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public Path createPath() {
        return new Path((Device)Display.getCurrent());
    }

    public void drawPath(Path path) {
        this.g.drawPath(path);
    }

    public void fillRectangle(Rectangle rect) {
        this.g.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawText(String string, int x, int y, Float rotate) {
        if (rotate != null) {
            this.g.pushState();
            this.g.rotate(rotate.floatValue());
        }
        this.g.drawText(string, x, y);
        if (rotate != null) {
            this.g.popState();
        }
    }

    public Point textExtent(String string) {
        Dimension result = TextUtilities.INSTANCE.getTextExtents(string, this.g.getFont());
        return new Point(result.width, result.height);
    }

    public FontMetrics getFontMetrics() {
        return this.g.getFontMetrics();
    }

    public void setAntialias(boolean state) {
        this.g.setAntialias(state ? 1 : 0);
    }
}

