/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.chart.draw2d.view;

import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.scada.chart.swt.ChartArea;
import org.eclipse.scada.ui.chart.model.Chart;
import org.eclipse.scada.ui.chart.selector.ChartInputSelector;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.scada.ui.chart.viewer.CompositeExtensionSpace;
import org.eclipse.scada.ui.chart.viewer.ExtensionSpaceProvider;
import org.eclipse.scada.ui.chart.viewer.ResetHandler;
import org.eclipse.scada.ui.utils.layout.GridLayoutFactory;
import org.eclipse.scada.vi.ui.chart.draw2d.ChartHelper;
import org.eclipse.scada.vi.ui.user.viewer.AbstractViewInstance;
import org.eclipse.scada.vi.ui.user.viewer.ViewInstanceDescriptor;
import org.eclipse.scada.vi.ui.user.viewer.ViewManagerContext;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.services.IEvaluationService;

public class ChartView
extends AbstractViewInstance {
    private ChartViewer chart;
    private final Composite viewHolder;
    private ChartArea chartArea;
    private final boolean showSelector;
    private SashForm wrapper;
    private Chart configuration;
    private ChartInputSelector selector;
    private final ViewManagerContext viewManagerContext;

    public ChartView(ViewManagerContext viewManagerContext, ResourceManager manager, ViewInstanceDescriptor descriptor, Composite viewHolder, IEvaluationService evaluationService, boolean showSelector) {
        super(viewManagerContext, descriptor, evaluationService);
        this.showSelector = showSelector;
        this.viewHolder = viewHolder;
        this.viewManagerContext = viewManagerContext;
    }

    public void setFocus() {
        this.chartArea.setFocus();
    }

    public Control getControl() {
        return this.wrapper;
    }

    protected void activateView() {
        if (this.chart != null) {
            return;
        }
        this.wrapper = new SashForm(this.viewHolder, 256);
        this.wrapper.setLayout((Layout)new FillLayout(256));
        Composite subWrapper = new Composite((Composite)this.wrapper, 0);
        subWrapper.setLayout((Layout)GridLayoutFactory.slimStack());
        Composite extensionSpace = new Composite(subWrapper, 0);
        extensionSpace.setLayoutData((Object)new GridData(4, 4, true, false));
        extensionSpace.setLayout((Layout)new RowLayout(256));
        this.chartArea = new ChartArea(subWrapper, 0);
        this.chartArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.configuration = ChartHelper.loadConfiguraton(this.descriptor.getUri().toString());
        this.chart = new ChartViewer(this.chartArea.getChartRenderer(), this.configuration, (ExtensionSpaceProvider)new CompositeExtensionSpace(extensionSpace), new ResetHandler(){

            public void reset() {
                ChartView.this.reload();
            }
        });
        if (this.showSelector) {
            this.selector = new ChartInputSelector((Composite)this.wrapper, this.chart, true);
            this.wrapper.setWeights(new int[]{85, 15});
        }
        this.viewManagerContext.setSelectionProvider((ISelectionProvider)this.chart);
        this.chart.setFocus();
    }

    protected void deactivateView() {
        this.viewManagerContext.setSelectionProvider(null);
        if (this.chart != null) {
            this.chart.dispose();
            this.chart = null;
        }
        if (this.chartArea != null) {
            this.chartArea.dispose();
            this.chartArea = null;
        }
        if (this.selector != null) {
            this.selector.dispose();
            this.selector = null;
        }
        if (this.wrapper != null) {
            this.wrapper.dispose();
            this.wrapper = null;
        }
    }
}

