/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.user.navigation.breadcrumb;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scada.vi.ui.user.Activator;
import org.eclipse.scada.vi.ui.user.navigation.breadcrumb.BreadcrumbBar;
import org.eclipse.scada.vi.ui.user.navigation.breadcrumb.BreadcrumbItem;
import org.eclipse.scada.vi.ui.user.viewer.ViewInstance;
import org.eclipse.scada.vi.ui.user.viewer.ViewInstanceDescriptor;
import org.eclipse.scada.vi.ui.user.viewer.ViewManager;
import org.eclipse.scada.vi.ui.user.viewer.ViewManagerAdapter;
import org.eclipse.scada.vi.ui.user.viewer.ViewManagerListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreadcrumbNavigator {
    private static final Logger logger = LoggerFactory.getLogger(BreadcrumbNavigator.class);
    private final ViewManagerListener viewManagerListener = new ViewManagerAdapter(){

        @Override
        public void viewActiveChanged(ViewInstance viewInstance, boolean state) {
            BreadcrumbNavigator.this.handleViewActiveChanged(viewInstance, state);
        }
    };
    private final ViewManager viewManager;
    private final BreadcrumbBar breadcrumbs;
    private List<ViewInstanceDescriptor> currentChain;

    public BreadcrumbNavigator(Composite parent, ViewManager viewManager, int style) {
        this.viewManager = viewManager;
        this.breadcrumbs = new BreadcrumbBar(parent, style);
        this.breadcrumbs.addSelectionListener(new BreadcrumbBar.BreadcrumbSelectionListener(){

            @Override
            public void selectionChanged(BreadcrumbItem item) {
                BreadcrumbNavigator.this.handleSelectionChanged(item);
            }
        });
        this.viewManager.addViewManagerListener(this.viewManagerListener);
    }

    protected void handleViewActiveChanged(ViewInstance viewInstance, boolean state) {
        logger.debug("View active changed: {} - {}", (Object)viewInstance.getDescriptor(), (Object)state);
        if (!state) {
            return;
        }
        try {
            List<ViewInstanceDescriptor> chain = this.buildChain(viewInstance.getDescriptor());
            this.setDescriptorChain(chain);
            this.breadcrumbs.layout();
        }
        catch (Exception e) {
            logger.warn("Failed to activate view", (Throwable)e);
        }
    }

    private boolean isSubChain(List<ViewInstanceDescriptor> descriptors) {
        if (this.currentChain == null || this.currentChain.isEmpty()) {
            return false;
        }
        int idx = Collections.indexOfSubList(this.currentChain, descriptors);
        return idx >= 0;
    }

    private void setDescriptorChain(List<ViewInstanceDescriptor> descriptors) {
        if (this.isSubChain(descriptors)) {
            this.breadcrumbs.setSelectionIndex(descriptors.size() - 1);
            return;
        }
        this.currentChain = descriptors;
        BreadcrumbItem[] breadcrumbItemArray = this.breadcrumbs.getItems();
        int n = breadcrumbItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            BreadcrumbItem item = breadcrumbItemArray[n2];
            item.dispose();
            ++n2;
        }
        if (descriptors.isEmpty()) {
            return;
        }
        int i = 0;
        int size = descriptors.size();
        for (ViewInstanceDescriptor descriptor : descriptors) {
            BreadcrumbItem item = new BreadcrumbItem(this.breadcrumbs, i + 1 >= size);
            item.setText(descriptor.getName());
            item.setData("DESC", descriptor);
            ++i;
        }
        this.breadcrumbs.setSelectionIndex(descriptors.size() - 1);
    }

    private List<ViewInstanceDescriptor> buildChain(ViewInstanceDescriptor descriptor) {
        LinkedList<ViewInstanceDescriptor> result = new LinkedList<ViewInstanceDescriptor>();
        ViewInstanceDescriptor currentDescriptor = descriptor;
        while (currentDescriptor != null) {
            result.add(0, currentDescriptor);
            currentDescriptor = Activator.findParent(currentDescriptor);
        }
        return result;
    }

    protected void handleSelectionChanged(BreadcrumbItem item) {
        Object o = item.getData("DESC");
        if (o instanceof ViewInstanceDescriptor) {
            this.viewManager.showView(((ViewInstanceDescriptor)o).getId());
        }
    }

    protected void handleDispose() {
        this.viewManager.removeViewManagerListener(this.viewManagerListener);
    }

    public void dispose() {
        this.breadcrumbs.dispose();
    }

    public Control getControl() {
        return this.breadcrumbs.getControl();
    }
}

