/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.data;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.scada.core.connection.provider.ConnectionIdTracker;
import org.eclipse.scada.core.connection.provider.ConnectionTracker;
import org.eclipse.scada.da.client.DataItem;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.connection.provider.ConnectionService;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.vi.data.RegistrationManager;
import org.osgi.framework.BundleContext;

public class DataItemRegistration
implements Observer {
    private final RegistrationManager registrationManager;
    private final String name;
    private final ConnectionIdTracker connectionTracker;
    private ConnectionService connectionService;
    private DataItem dataItem;
    private final boolean ignoreSummary;
    private final boolean nullInvalid;
    private final Item item;

    public DataItemRegistration(RegistrationManager registrationManager, BundleContext context, String name, String itemId, String connectionId, boolean ignoreSummary, boolean nullInvalid) {
        this.registrationManager = registrationManager;
        this.name = name;
        this.item = new Item(connectionId, itemId, Item.Type.ID);
        this.ignoreSummary = ignoreSummary;
        this.nullInvalid = nullInvalid;
        this.connectionTracker = new ConnectionIdTracker(context, connectionId, new ConnectionTracker.Listener(){

            public void setConnection(org.eclipse.scada.core.connection.provider.ConnectionService connectionService) {
                DataItemRegistration.this.setConnection(connectionService);
            }
        });
    }

    public void open() {
        this.connectionTracker.open();
    }

    public void close() {
        this.connectionTracker.close();
        this.disconnect();
        this.notifyChange(DataItemValue.DISCONNECTED);
    }

    public boolean isIgnoreSummary() {
        return this.ignoreSummary;
    }

    public boolean isNullInvalid() {
        return this.nullInvalid;
    }

    public Item getItem() {
        return this.item;
    }

    protected synchronized void setConnection(org.eclipse.scada.core.connection.provider.ConnectionService connectionService) {
        this.disconnect();
        if (connectionService instanceof ConnectionService) {
            this.connectionService = (ConnectionService)connectionService;
            this.dataItem = new DataItem(this.item.getId());
            this.dataItem.addObserver((Observer)this);
            this.dataItem.register(this.connectionService.getItemManager());
        }
        if (this.connectionService == null) {
            this.notifyChange(DataItemValue.DISCONNECTED);
        }
    }

    private void disconnect() {
        if (this.connectionService != null) {
            this.connectionService = null;
        }
        if (this.dataItem != null) {
            this.dataItem.deleteObservers();
            this.dataItem.unregister();
            this.dataItem = null;
        }
    }

    public void notifyChange(DataItemValue value) {
        this.registrationManager.notifyChange(this.name, this.item, value, this.ignoreSummary, this.nullInvalid);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this.dataItem && arg instanceof DataItemValue) {
            this.notifyChange((DataItemValue)arg);
        }
    }
}

