/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.client.net;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import org.apache.mina.core.session.IoSession;
import org.eclipse.scada.ae.BrowserListener;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.Query;
import org.eclipse.scada.ae.QueryListener;
import org.eclipse.scada.ae.client.Connection;
import org.eclipse.scada.ae.client.EventListener;
import org.eclipse.scada.ae.client.MonitorListener;
import org.eclipse.scada.ae.client.net.DriverFactoryImpl;
import org.eclipse.scada.ae.client.net.QueryImpl;
import org.eclipse.scada.ae.data.BrowserEntry;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.data.QueryState;
import org.eclipse.scada.ae.net.BrowserMessageHelper;
import org.eclipse.scada.ae.net.EventMessageHelper;
import org.eclipse.scada.ae.net.MonitorMessageHelper;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.client.net.MessageFuture;
import org.eclipse.scada.core.client.net.SessionConnectionBase;
import org.eclipse.scada.core.data.OperationParameters;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.net.MessageHelper;
import org.eclipse.scada.net.base.MessageListener;
import org.eclipse.scada.net.base.MessageStateListener;
import org.eclipse.scada.net.base.data.IntegerValue;
import org.eclipse.scada.net.base.data.LongValue;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.net.utils.MessageCreator;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionImpl
extends SessionConnectionBase
implements Connection {
    private static final String MESSAGE_QUERY_ID = "queryId";
    public static final String VERSION = "0.1.0";
    private static final Logger logger;
    private final Map<String, MonitorListener> monitorListeners = new HashMap<String, MonitorListener>();
    private final Map<String, EventListener> eventListeners = new HashMap<String, EventListener>();
    private final Set<BrowserListener> browserListeners = new CopyOnWriteArraySet<BrowserListener>();
    private final Map<String, BrowserEntry> browserCache = new HashMap<String, BrowserEntry>();
    private final Map<Long, QueryImpl> queries = new HashMap<Long, QueryImpl>();
    private final Random random = new Random();

    static {
        DriverFactoryImpl.registerDriver();
        logger = LoggerFactory.getLogger(ConnectionImpl.class);
    }

    public String getRequiredVersion() {
        return VERSION;
    }

    public ConnectionImpl(ConnectionInformation connectionInformantion) {
        super(connectionInformantion);
        this.init();
    }

    protected void init() {
        this.messenger.setHandler(196627, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ConnectionImpl.this.handleConditionStatus(message);
            }
        });
        this.messenger.setHandler(196628, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ConnectionImpl.this.handleConditionData(message);
            }
        });
        this.messenger.setHandler(196611, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ConnectionImpl.this.handleEventStatus(message);
            }
        });
        this.messenger.setHandler(196612, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ConnectionImpl.this.handleEventData(message);
            }
        });
        this.messenger.setHandler(196641, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ConnectionImpl.this.handleBrowserUpdate(message);
            }
        });
        this.messenger.setHandler(196659, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ConnectionImpl.this.handleQueryStateChange(message);
            }
        });
        this.messenger.setHandler(196660, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ConnectionImpl.this.handleQueryData(message);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleQueryData(final Message message) {
        Long queryId = this.queryIdFromMessage(message);
        if (queryId == null) {
            logger.warn("Query update without query id");
            return;
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            final QueryImpl query = this.queries.get(queryId);
            if (query == null) {
                logger.warn("Unknown query {}", (Object)queryId);
                return;
            }
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    query.handleData(EventMessageHelper.fromValue((Value)message.getValues().get("data")));
                }
            });
        }
        this.messenger.sendMessage(MessageCreator.createACK((Message)message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleQueryStateChange(Message message) {
        Long queryId = this.queryIdFromMessage(message);
        if (queryId == null) {
            logger.warn("Query update without query id");
            return;
        }
        QueryState state = this.queryStateFromMessage(message);
        if (state == null) {
            logger.warn("Query update without query state");
            return;
        }
        Value errorValue = message.getValues().get("error");
        String error = errorValue != null ? errorValue.toString() : null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            final QueryImpl query = this.queries.get(queryId);
            if (query == null) {
                logger.warn("Unknown query {}", (Object)queryId);
                return;
            }
            switch (state) {
                case DISCONNECTED: {
                    this.queries.remove(queryId);
                    this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            query.dispose();
                        }
                    });
                    break;
                }
                default: {
                    this.fireQueryStateChange(query, state, error != null ? new RuntimeException(error).fillInStackTrace() : null);
                }
            }
        }
    }

    private QueryState queryStateFromMessage(Message message) {
        QueryState state = null;
        Value value = message.getValues().get("state");
        if (value instanceof StringValue) {
            state = QueryState.valueOf((String)((StringValue)value).getValue());
        }
        return state;
    }

    private Long queryIdFromMessage(Message message) {
        Long queryId = null;
        Value value = message.getValues().get(MESSAGE_QUERY_ID);
        if (value instanceof LongValue) {
            queryId = ((LongValue)value).getValue();
        }
        return queryId;
    }

    protected synchronized void handleBrowserUpdate(Message message) {
        List added = BrowserMessageHelper.fromValue((Value)message.getValues().get("added"));
        Set removed = BrowserMessageHelper.fromValueRemoved((Value)message.getValues().get("removed"));
        boolean full = message.getValues().containsKey("full");
        if (full) {
            this.browserCache.clear();
        }
        if (removed != null) {
            for (String id : removed) {
                this.browserCache.remove(id);
            }
        }
        if (added != null) {
            for (BrowserEntry entry : added) {
                this.browserCache.put(entry.getId(), entry);
            }
        }
        this.fireBrowserListener(added, removed, full);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void handleEventData(Message message) {
        String queryId = null;
        Value value = message.getValues().get(MESSAGE_QUERY_ID);
        if (value instanceof StringValue) {
            queryId = ((StringValue)value).getValue();
        }
        List data = EventMessageHelper.fromValue((Value)message.getValues().get("events"));
        if (queryId != null && data != null) {
            EventListener listener;
            Map<String, EventListener> map = this.eventListeners;
            synchronized (map) {
                listener = this.eventListeners.get(queryId);
            }
            this.fireEventDataChange(listener, data);
        }
        this.messenger.sendMessage(MessageCreator.createACK((Message)message));
    }

    private void fireEventDataChange(final EventListener listener, final List<Event> data) {
        logger.debug("Received: {} events", (Object)data.size());
        if (listener == null) {
            return;
        }
        try {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.dataChanged(data);
                }
            });
        }
        catch (Throwable e) {
            logger.warn("Failed to notify", e);
        }
    }

    protected synchronized void handleConditionData(Message message) {
        try {
            logger.debug("Got condition data");
            String queryId = null;
            Value value = message.getValues().get(MESSAGE_QUERY_ID);
            if (value instanceof StringValue) {
                queryId = ((StringValue)value).getValue();
            }
            List data = MonitorMessageHelper.fromValue((Value)message.getValues().get("conditions.addedOrUpdated"));
            Set removed = MonitorMessageHelper.fromValueRemoved((Value)message.getValues().get("conditions.removed"));
            if (queryId != null && (data != null || removed != null)) {
                MonitorListener listener = this.monitorListeners.get(queryId);
                this.fireConditionDataChange(listener, data, removed, false);
            } else {
                logger.info("Nothing to notify");
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to handle condition data", e);
        }
    }

    private void fireConditionDataChange(final MonitorListener listener, final List<MonitorStatusInformation> addedOrUpdated, final Set<String> removed, final boolean full) {
        if (listener == null) {
            logger.warn("Condition change data without a listener");
            return;
        }
        try {
            logger.debug("notify condition data change");
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.dataChanged(addedOrUpdated, removed, full);
                }
            });
        }
        catch (Throwable e) {
            logger.warn("Failed to notify", e);
        }
    }

    protected synchronized void handleEventStatus(Message message) {
        String queryId = null;
        Value value = message.getValues().get(MESSAGE_QUERY_ID);
        if (value instanceof StringValue) {
            queryId = ((StringValue)value).getValue();
        }
        SubscriptionState status = null;
        Value value2 = message.getValues().get("status");
        if (value2 instanceof StringValue) {
            String statusString = ((StringValue)value2).getValue();
            status = SubscriptionState.valueOf((String)statusString);
        }
        if (queryId != null && status != null) {
            logger.debug("event status change: {} -> {}", new Object[]{queryId, status});
            EventListener listener = this.eventListeners.get(queryId);
            this.fireEventStatusChange(listener, status);
        }
    }

    protected synchronized void handleConditionStatus(Message message) {
        String queryId = null;
        Value value = message.getValues().get(MESSAGE_QUERY_ID);
        if (value instanceof StringValue) {
            queryId = ((StringValue)value).getValue();
        }
        SubscriptionState status = null;
        Value value2 = message.getValues().get("status");
        if (value2 instanceof StringValue) {
            String statusString = ((StringValue)value2).getValue();
            status = SubscriptionState.valueOf((String)statusString);
        }
        if (queryId != null && status != null) {
            MonitorListener listener = this.monitorListeners.get(queryId);
            this.fireConditionStatusChange(listener, status);
        }
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public synchronized Query createQuery(String queryType, String queryData, QueryListener listener) {
        Long l;
        if (!this.isConnected()) {
            return null;
        }
        while (this.queries.containsValue(l = Long.valueOf(this.random.nextLong()))) {
        }
        logger.debug("Using new query id: {}");
        QueryImpl query = new QueryImpl(this, l, listener);
        this.queries.put(l, query);
        this.fireQueryStateChange(query, QueryState.CONNECTING, null);
        this.sendCreateQuery(l, queryType, queryData);
        return query;
    }

    private void sendCreateQuery(long queryId, String queryType, String queryData) {
        Message message = new Message(196657);
        message.getValues().put(MESSAGE_QUERY_ID, (Value)new LongValue(queryId));
        message.getValues().put("queryType", (Value)new StringValue(queryType));
        message.getValues().put("queryData", (Value)new StringValue(queryData));
        this.messenger.sendMessage(message);
    }

    public synchronized void setMonitorListener(String conditionQueryId, MonitorListener listener) {
        if (listener == null) {
            this.clearConditionListener(conditionQueryId);
        } else {
            this.updateConditionListener(conditionQueryId, listener);
        }
    }

    private void updateConditionListener(String conditionQueryId, MonitorListener listener) {
        MonitorListener oldListener = this.monitorListeners.put(conditionQueryId, listener);
        if (oldListener == listener) {
            return;
        }
        if (oldListener != null) {
            this.fireConditionStatusChange(oldListener, SubscriptionState.DISCONNECTED);
        } else {
            this.sendSubscribeConditions(conditionQueryId, true);
        }
        this.fireConditionStatusChange(listener, SubscriptionState.DISCONNECTED);
    }

    private void clearConditionListener(String conditionQueryId) {
        MonitorListener oldListener = this.monitorListeners.remove(conditionQueryId);
        if (oldListener != null) {
            this.sendSubscribeConditions(conditionQueryId, false);
        }
        if (oldListener != null) {
            this.fireConditionStatusChange(oldListener, SubscriptionState.DISCONNECTED);
        }
    }

    private void sendSubscribeConditions(String conditionQueryId, boolean flag) {
        logger.info("Requesting conditions: " + conditionQueryId + "/" + flag);
        Message message = new Message(flag ? 196625 : 196626);
        message.getValues().put(MESSAGE_QUERY_ID, (Value)new StringValue(conditionQueryId));
        this.messenger.sendMessage(message);
    }

    private void fireConditionStatusChange(final MonitorListener listener, final SubscriptionState status) {
        if (listener == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                listener.statusChanged(status);
            }
        });
    }

    public synchronized void setEventListener(String eventQueryId, EventListener listener) {
        if (listener == null) {
            this.clearEventListener(eventQueryId);
        } else {
            this.updateEventListener(eventQueryId, listener);
        }
    }

    private void updateEventListener(String eventQueryId, EventListener listener) {
        EventListener oldListener = this.eventListeners.put(eventQueryId, listener);
        if (oldListener == listener) {
            return;
        }
        if (oldListener != null) {
            this.fireEventStatusChange(oldListener, SubscriptionState.DISCONNECTED);
        } else {
            this.sendSubscribeEventQuery(eventQueryId, true);
        }
        this.fireEventStatusChange(listener, SubscriptionState.DISCONNECTED);
    }

    private void clearEventListener(String eventQueryId) {
        EventListener oldListener = this.eventListeners.remove(eventQueryId);
        if (oldListener != null) {
            this.sendSubscribeEventQuery(eventQueryId, false);
        }
        if (oldListener != null) {
            this.fireEventStatusChange(oldListener, SubscriptionState.DISCONNECTED);
        }
    }

    private void fireEventStatusChange(final EventListener listener, final SubscriptionState status) {
        if (listener == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                listener.statusChanged(status);
            }
        });
    }

    private void sendSubscribeEventQuery(String eventQueryId, boolean flag) {
        Message message = new Message(flag ? 196609 : 196610);
        message.getValues().put(MESSAGE_QUERY_ID, (Value)new StringValue(eventQueryId));
        this.messenger.sendMessage(message);
    }

    protected synchronized void onConnectionBound() {
        super.onConnectionBound();
        for (String key : this.eventListeners.keySet()) {
            this.sendSubscribeEventQuery(key, true);
        }
        for (String key : this.monitorListeners.keySet()) {
            this.sendSubscribeConditions(key, true);
        }
    }

    public synchronized void sessionClosed(IoSession session) throws Exception {
        for (MonitorListener monitorListener : this.monitorListeners.values()) {
            this.fireConditionStatusChange(monitorListener, SubscriptionState.DISCONNECTED);
        }
        for (EventListener eventListener : this.eventListeners.values()) {
            this.fireEventStatusChange(eventListener, SubscriptionState.DISCONNECTED);
        }
        for (final QueryImpl queryImpl : this.queries.values()) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    queryImpl.dispose();
                }
            });
        }
        this.queries.clear();
        this.browserCache.clear();
        this.fireBrowserListener(null, null, true);
        super.sessionClosed(session);
    }

    private void fireQueryStateChange(final QueryImpl query, final QueryState state, final Throwable error) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                query.handleStateChange(state, error);
            }
        });
    }

    public synchronized void addBrowserListener(final BrowserListener listener) {
        if (listener == null) {
            return;
        }
        if (this.browserListeners.add(listener)) {
            final ArrayList<BrowserEntry> addedOrChanged = new ArrayList<BrowserEntry>(this.browserCache.values());
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.dataChanged(addedOrChanged, null, true);
                }
            });
        }
    }

    public synchronized void removeBrowserListener(BrowserListener listener) {
        if (listener == null) {
            return;
        }
        this.browserListeners.remove(listener);
    }

    protected void fireBrowserListener(final List<BrowserEntry> added, final Set<String> removed, final boolean full) {
        final HashSet<BrowserListener> listeners = new HashSet<BrowserListener>(this.browserListeners);
        if (listeners.isEmpty()) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (BrowserListener listener : listeners) {
                    try {
                        listener.dataChanged(added, removed, full);
                    }
                    catch (Throwable e) {
                        logger.warn("Failed to notify browser change", e);
                    }
                }
            }
        });
    }

    public NotifyFuture<Void> acknowledge(String monitorId, Date aknTimestamp, OperationParameters operationParameters, CallbackHandler callbackHandler) {
        logger.debug("Sending ACK: {} / {}", new Object[]{monitorId, aknTimestamp});
        Message message = new Message(196629);
        message.getValues().put("id", (Value)new StringValue(monitorId));
        if (aknTimestamp != null) {
            message.getValues().put("aknTimestamp", (Value)new LongValue(aknTimestamp.getTime()));
        } else {
            message.getValues().put("aknTimestamp", (Value)new LongValue(System.currentTimeMillis()));
        }
        MessageHelper.encodeOperationParameters((OperationParameters)operationParameters, (Message)message);
        MessageFuture<Void> messageListenerer = new MessageFuture<Void>(){

            protected Void process(Message message) throws Exception {
                return null;
            }
        };
        this.messenger.sendMessage(message, (MessageStateListener)messageListenerer);
        return messageListenerer;
    }

    public synchronized void closeQuery(long queryId) {
        QueryImpl query = this.queries.get(queryId);
        if (query == null) {
            logger.warn("Query {} closed", (Object)queryId);
            return;
        }
        this.sendCloseQuery(queryId);
    }

    private void sendCloseQuery(long queryId) {
        Message message = new Message(196658);
        message.getValues().put(MESSAGE_QUERY_ID, (Value)new LongValue(queryId));
        this.messenger.sendMessage(message);
    }

    public synchronized void loadMore(long queryId, int count) {
        QueryImpl query = this.queries.get(queryId);
        if (query == null) {
            logger.warn("Query {} closed", (Object)queryId);
            return;
        }
        this.sendLoadMoreQuery(queryId, count);
    }

    private void sendLoadMoreQuery(long queryId, int count) {
        Message message = new Message(196661);
        message.getValues().put(MESSAGE_QUERY_ID, (Value)new LongValue(queryId));
        message.getValues().put("count", (Value)new IntegerValue(count));
        this.messenger.sendMessage(message);
    }
}

