/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.views;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.client.EventListener;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.ui.views.Activator;
import org.eclipse.scada.ae.ui.views.CustomizableAction;
import org.eclipse.scada.ae.ui.views.config.ColumnLabelProviderInformation;
import org.eclipse.scada.ae.ui.views.config.ConfigurationHelper;
import org.eclipse.scada.ae.ui.views.config.EventPoolViewConfiguration;
import org.eclipse.scada.ae.ui.views.dialog.EventHistorySearchDialog;
import org.eclipse.scada.ae.ui.views.dialog.SearchType;
import org.eclipse.scada.ae.ui.views.model.DecoratedEvent;
import org.eclipse.scada.ae.ui.views.model.DecoratedMonitor;
import org.eclipse.scada.ae.ui.views.model.MonitorData;
import org.eclipse.scada.ae.ui.views.views.ColumnProperties;
import org.eclipse.scada.ae.ui.views.views.EventViewTable;
import org.eclipse.scada.ae.ui.views.views.Messages;
import org.eclipse.scada.ae.ui.views.views.MonitorSubscriptionAlarmsEventsView;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.lang.Pair;
import org.eclipse.scada.utils.str.StringHelper;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventPoolView
extends MonitorSubscriptionAlarmsEventsView {
    private static final Logger logger = LoggerFactory.getLogger(EventPoolView.class);
    public static final String ID = "org.eclipse.scada.ae.ui.views.views.eventpool";
    private String poolId;
    private WritableSet pool;
    private EventListener eventPoolListener;
    private final Map<String, Set<DecoratedEvent>> poolMap = new HashMap<String, Set<DecoratedEvent>>();
    private EventViewTable eventsTable;
    private List<ColumnProperties> initialColumnSettings;
    private final Gson gson = new GsonBuilder().create();
    private final Object jobLock = new Object();
    private Collection<Event> eventList;
    private ScheduledExecutorService scheduler;
    private int maxNumberOfEvents = 0;
    private int forceEventLimit = 0;
    private List<ColumnLabelProviderInformation> columnInformation;
    protected SubscriptionState eventPoolSubscriptionState;

    public String getPoolId() {
        return this.poolId;
    }

    public void setPoolId(String poolId) {
        if (poolId == null) {
            this.unSubscribe();
            this.poolId = null;
            return;
        }
        if (!String.valueOf(poolId).equals(String.valueOf(this.poolId))) {
            this.unSubscribe();
            this.poolId = poolId;
            this.subscribe();
        }
    }

    @Override
    public void createPartControl(final Composite parent) {
        super.createPartControl(parent);
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("shortenEventPool"));
        int shortenEverySeconds = Activator.getDefault().getPreferenceStore().getInt("cutListAllSeconds");
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                EventPoolView.this.scheduleJob(new Runnable(){

                    @Override
                    public void run() {
                        EventPoolView.this.removeEvents();
                        EventPoolView.this.updateStatusBar();
                    }
                });
            }
        }, shortenEverySeconds, shortenEverySeconds, TimeUnit.SECONDS);
        this.pool = new WritableSet(SWTObservables.getRealm((Display)parent.getDisplay()));
        this.pool.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                EventPoolView.this.updateStatusBar();
            }
        });
        final CustomizableAction scrollLockAction = new CustomizableAction(Messages.EventPoolView_Action_ScrollLock_Name, 2);
        scrollLockAction.setToolTipText(Messages.EventPoolView_Action_ScrollLock_ToolTip);
        scrollLockAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/scroll_lock.gif")));
        scrollLockAction.setRunnable(new Runnable(){

            @Override
            public void run() {
                EventPoolView.this.eventsTable.setScrollLock(scrollLockAction.isChecked());
            }
        });
        final CustomizableAction setFilterAction = new CustomizableAction("", 2);
        setFilterAction.setText(Messages.EventPoolView_Action_Filter_Name);
        setFilterAction.setToolTipText(Messages.EventPoolView_Action_Filter_ToolTip);
        setFilterAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/search.gif")));
        setFilterAction.setRunnable(new Runnable(){

            @Override
            public void run() {
                setFilterAction.setChecked(true);
                final Pair<SearchType, String> result = EventHistorySearchDialog.open(parent.getShell(), EventPoolView.this.eventsTable.getFilter());
                BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        EventPoolView.this.eventsTable.setFilter((Pair<SearchType, String>)result);
                        setFilterAction.setChecked(EventPoolView.this.eventsTable.getFilter() != null);
                        EventPoolView.this.updateStatusBar();
                    }
                });
            }
        });
        CustomizableAction removeFilterAction = new CustomizableAction();
        removeFilterAction.setText(Messages.EventPoolView_Action_RemoveFilter_Name);
        removeFilterAction.setToolTipText(Messages.EventPoolView_Action_RemoveFilter_ToolTip);
        removeFilterAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/clear_search.gif")));
        removeFilterAction.setRunnable(new Runnable(){

            @Override
            public void run() {
                BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        EventPoolView.this.eventsTable.removeFilter();
                        setFilterAction.setChecked(false);
                        EventPoolView.this.updateStatusBar();
                    }
                });
            }
        });
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)scrollLockAction);
        toolBarManager.add((IAction)setFilterAction);
        toolBarManager.add((IAction)removeFilterAction);
        this.loadConfiguration();
        this.eventsTable = new EventViewTable(this.getContentPane(), this.getViewSite(), 2048, this.pool, this.initialColumnSettings, this.columnInformation);
        this.eventsTable.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.getSite().setSelectionProvider((ISelectionProvider)this.eventsTable.getTableViewer());
    }

    private void loadConfiguration() {
        EventPoolViewConfiguration cfg = ConfigurationHelper.findEventPoolViewConfiguration(this.getViewSite().getSecondaryId());
        if (cfg != null) {
            try {
                this.setConfiguration(cfg);
            }
            catch (Exception e) {
                logger.warn("Failed to apply configuration", (Throwable)e);
            }
        } else {
            logger.info("no configuration found");
        }
    }

    protected void setConfiguration(EventPoolViewConfiguration cfg) throws Exception {
        this.setPoolId(cfg.getEventPoolQueryId());
        this.setMonitorsId(cfg.getMonitorQueryId());
        switch (cfg.getConnectionType()) {
            case URI: {
                this.setConnectionUri(cfg.getConnectionString());
                break;
            }
            case ID: {
                this.setConnectionId(cfg.getConnectionString());
            }
        }
        if (cfg.getLabel() != null) {
            this.setPartName(cfg.getLabel());
        }
        int maxNumberOfEvents = cfg.getMaxNumberOfEvents();
        if (Activator.getDefault().getPreferenceStore().getInt("numberOfEvents") > 0) {
            maxNumberOfEvents = Activator.getDefault().getPreferenceStore().getInt("numberOfEvents");
        }
        this.maxNumberOfEvents = maxNumberOfEvents;
        this.forceEventLimit = cfg.getForceEventLimit();
        this.columnInformation = cfg.getColumnInformation();
    }

    public void setFocus() {
        this.eventsTable.setFocus();
    }

    @Override
    protected void subscribe() {
        super.subscribe();
        if (this.getConnection() != null && this.poolId != null) {
            this.eventPoolListener = new EventListener(){

                public void statusChanged(SubscriptionState state) {
                    EventPoolView.this.statusChangedEventSubscription(state);
                }

                public void dataChanged(List<Event> addedEvents) {
                    EventPoolView.this.dataChanged(addedEvents);
                }
            };
            this.getConnectionService().getEventManager().addEventListener(this.poolId, this.eventPoolListener);
        }
    }

    @Override
    protected void unSubscribe() {
        super.unSubscribe();
        if (this.getConnection() != null && this.poolId != null && this.eventPoolListener != null) {
            this.getConnectionService().getEventManager().removeEventListener(this.poolId, this.eventPoolListener);
        }
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dataChanged(List<Event> addedEvents) {
        Object object = this.jobLock;
        synchronized (object) {
            boolean created = false;
            if (this.eventList == null) {
                this.eventList = new ArrayList<Event>();
                created = true;
            }
            this.eventList.addAll(addedEvents);
            if (created) {
                this.getRealm().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EventPoolView.this.getRealm().timerExec(1000, new Runnable(){

                            @Override
                            public void run() {
                                EventPoolView.this.processEvents();
                            }
                        });
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvents() {
        Collection<Event> list;
        Object object = this.jobLock;
        synchronized (object) {
            list = this.eventList;
            this.eventList = null;
        }
        if (list != null) {
            this.performDataChanged(list);
        }
    }

    private void performDataChanged(Collection<Event> addedEvents) {
        if (addedEvents == null || addedEvents.isEmpty()) {
            return;
        }
        final Set<DecoratedEvent> decoratedEvents = this.decorateEvents(addedEvents);
        for (DecoratedEvent event : decoratedEvents) {
            Variant source = event.getEvent().getField(Event.Fields.SOURCE);
            if (source == null || source.isNull() || source.asString("").length() <= 0) continue;
            String str = source.asString("");
            Set<DecoratedEvent> d = this.poolMap.get(str);
            if (d == null) {
                d = new HashSet<DecoratedEvent>();
                this.poolMap.put(str, d);
            }
            d.add(event);
        }
        if (addedEvents.size() > 10) {
            BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    EventPoolView.this.insertElements(decoratedEvents);
                }
            });
        } else {
            this.insertElements(decoratedEvents);
        }
    }

    private void insertElements(Set<DecoratedEvent> decoratedEvents) {
        Table table = this.eventsTable.getTableViewer().getTable();
        TableItem item = null;
        try {
            item = table.getItem(table.getTopIndex());
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.pool.addAll(decoratedEvents);
        if (item != null) {
            try {
                if (this.eventsTable.isScrollLock()) {
                    table.setTopIndex(table.indexOf(item));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void removeEvents() {
        if (this.maxNumberOfEvents <= 0) {
            return;
        }
        if (this.eventsTable.isScrollLock() && (this.forceEventLimit <= 0 || this.pool.size() < this.forceEventLimit)) {
            return;
        }
        try {
            ArrayList tmpList = new ArrayList(this.pool);
            ArrayList<DecoratedEvent> toRemove = new ArrayList<DecoratedEvent>();
            Collections.sort(tmpList, new Comparator<DecoratedEvent>(){

                @Override
                public int compare(DecoratedEvent e1, DecoratedEvent e2) {
                    return e2.compareTo(e1);
                }
            });
            int i = 0;
            for (DecoratedEvent event : tmpList) {
                if (i > this.maxNumberOfEvents) {
                    toRemove.add(event);
                }
                ++i;
            }
            this.pool.removeAll(toRemove);
            tmpList.clear();
            toRemove.clear();
        }
        catch (Throwable th) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.scada.ae.ui.views", 42, Messages.EventPoolView_Status_Error_RemoveElement, th));
        }
    }

    @Override
    public void dataChanged(final List<MonitorStatusInformation> addedOrUpdated, final Set<String> removed, final boolean full) {
        super.dataChanged(addedOrUpdated, removed, full);
        this.scheduleJob(new Runnable(){

            @Override
            public void run() {
                EventPoolView.this.performDataChanged(addedOrUpdated, removed, full);
            }
        });
    }

    private void performDataChanged(List<MonitorStatusInformation> addedOrUpdated, Set<String> removed, boolean full) {
        this.pool.addAll(this.decorateEvents(addedOrUpdated, removed, full));
    }

    private Set<DecoratedEvent> decorateEvents(List<MonitorStatusInformation> monitors, Set<String> removed, boolean full) {
        Set<DecoratedEvent> d;
        HashSet<DecoratedEvent> result = new HashSet<DecoratedEvent>();
        if (monitors != null) {
            for (MonitorStatusInformation monitorStatusInformation : monitors) {
                d = this.poolMap.get(monitorStatusInformation.getId());
                if (d == null) continue;
                for (DecoratedEvent event : d) {
                    event.setMonitor(new MonitorData(monitorStatusInformation));
                    result.add(event);
                }
            }
        }
        if (removed != null) {
            for (String monitorId : removed) {
                d = this.poolMap.get(monitorId);
                if (d == null) continue;
                for (DecoratedEvent event : d) {
                    event.setMonitor(null);
                    result.add(event);
                }
            }
        }
        return result;
    }

    private Set<DecoratedEvent> decorateEvents(Collection<Event> events) {
        HashSet<DecoratedEvent> result = new HashSet<DecoratedEvent>();
        for (Event event : events) {
            DecoratedMonitor decoratedMonitor;
            Variant source = event.getField(Event.Fields.SOURCE);
            MonitorData monitor = source != null && !source.isNull() && source.isString() ? ((decoratedMonitor = (DecoratedMonitor)this.monitorsMap.get((Object)source.asString(""))) != null ? decoratedMonitor.getMonitor() : null) : null;
            result.add(new DecoratedEvent(event, monitor));
        }
        return result;
    }

    private void clear() {
        this.pool.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (EventPoolView.this.pool != null) {
                    EventPoolView.this.pool.clear();
                }
            }
        });
    }

    private void statusChangedEventSubscription(SubscriptionState state) {
        this.eventPoolSubscriptionState = state;
        this.updateStatusBar();
    }

    @Override
    protected void watchPool(String poolId) {
        this.setPoolId(poolId);
    }

    @Override
    protected void watchMonitors(String monitorsId) {
        this.setMonitorsId(monitorsId);
    }

    @Override
    protected void updateStatusBar() {
        this.scheduleJob(new Runnable(){

            @Override
            public void run() {
                EventPoolView.this.setStatusBarText(EventPoolView.this.createStatusLabel());
            }
        });
    }

    protected String createStatusLabel() {
        LinkedList<String> labels = new LinkedList<String>();
        labels.add(this.getLabelForConnection());
        if (this.eventPoolSubscriptionState != null) {
            labels.add(this.eventPoolSubscriptionState.toString());
        }
        if (this.poolId != null) {
            labels.add(String.format(Messages.EventPoolView_Label_Format_Pool, this.poolId));
        } else {
            labels.add(Messages.EventPoolView_Label_Format_NoPool);
        }
        if (this.monitorsId != null) {
            labels.add(String.format(Messages.EventPoolView_Label_Format_Monitors, this.monitorsId));
        } else {
            labels.add(Messages.EventPoolView_Label_Format_NoMonitors);
        }
        labels.add(String.format(Messages.EventPoolView_Label_Format_CountEvents, this.pool.size()));
        Pair<SearchType, String> filter = this.eventsTable.getFilter();
        if (filter != null && filter.second != null && !((String)filter.second).isEmpty()) {
            labels.add(String.format(Messages.EventPoolView_Label_Format_Filter, filter.second).replace("&", "&&"));
        }
        return StringHelper.join(labels, (String)Messages.EventPoolView_Sep);
    }

    @Override
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String s;
        super.init(site, memento);
        if (memento != null && (s = memento.getString("columnSettings")) != null) {
            this.initialColumnSettings = (List)this.gson.fromJson(s, new TypeToken<List<ColumnProperties>>(){}.getType());
        }
    }

    @Override
    public void saveState(IMemento memento) {
        memento.putString("columnSettings", this.gson.toJson(this.eventsTable.getColumnSettings()));
        super.saveState(memento);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.unSubscribe();
        this.scheduler.shutdown();
        this.scheduler = null;
    }

    private void setStatusBarText(String string) {
        if (this.getStateLabel().isDisposed()) {
            return;
        }
        this.getStateLabel().setText(string);
    }
}

