/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.views;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.scada.ae.client.MonitorListener;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.ui.views.model.DecoratedMonitor;
import org.eclipse.scada.ae.ui.views.views.AbstractAlarmsEventsView;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public abstract class MonitorSubscriptionAlarmsEventsView
extends AbstractAlarmsEventsView {
    protected String monitorsId;
    protected WritableSet monitors;
    protected WritableMap monitorsMap;
    private MonitorListener monitorListener;
    protected SubscriptionState monitorSubscriptionState;

    @Override
    protected Realm getRealm() {
        if (this.monitors != null) {
            return this.monitors.getRealm();
        }
        return SWTObservables.getRealm((Display)this.getSite().getShell().getDisplay());
    }

    public void setMonitorsId(String monitorsId) {
        if (monitorsId == null) {
            this.unSubscribe();
            this.monitorsId = null;
            return;
        }
        if (!String.valueOf(monitorsId).equals(String.valueOf(this.monitorsId))) {
            this.unSubscribe();
            this.monitorsId = monitorsId;
            this.subscribe();
        }
    }

    public String getMonitorsId() {
        return this.monitorsId;
    }

    protected void subscribe() {
        if (this.getConnection() != null && this.monitorsId != null) {
            this.monitorListener = new MonitorListener(){

                public void statusChanged(SubscriptionState state) {
                    MonitorSubscriptionAlarmsEventsView.this.statusChangedMonitorSubscription(state);
                }

                public void dataChanged(List<MonitorStatusInformation> addedOrUpdated, Set<String> removed, boolean full) {
                    MonitorSubscriptionAlarmsEventsView.this.dataChanged(addedOrUpdated, removed, full);
                }
            };
            this.getConnectionService().getMonitorManager().addMonitorListener(this.monitorsId, this.monitorListener);
        }
    }

    protected void unSubscribe() {
        if (this.getConnection() != null && this.monitorsId != null && this.monitorListener != null) {
            this.getConnectionService().getMonitorManager().removeMonitorListener(this.monitorsId, this.monitorListener);
        }
        this.clear();
    }

    private void clear() {
        this.monitors.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (MonitorSubscriptionAlarmsEventsView.this.monitors != null) {
                    MonitorSubscriptionAlarmsEventsView.this.monitors.clear();
                }
                if (MonitorSubscriptionAlarmsEventsView.this.monitorsMap != null) {
                    MonitorSubscriptionAlarmsEventsView.this.monitorsMap.clear();
                }
            }
        });
    }

    @Override
    protected void onConnect() {
        super.onConnect();
        this.subscribe();
    }

    @Override
    protected void onDisconnect() {
        this.unSubscribe();
        super.onDisconnect();
    }

    public void statusChangedMonitorSubscription(SubscriptionState state) {
        this.monitorSubscriptionState = state;
        this.updateStatusBar();
    }

    protected void dataChanged(final List<MonitorStatusInformation> addedOrUpdated, final Set<String> removed, final boolean full) {
        this.scheduleJob(new Runnable(){

            @Override
            public void run() {
                MonitorSubscriptionAlarmsEventsView.this.performDataChanged(addedOrUpdated, removed, full);
            }
        });
    }

    private void performDataChanged(List<MonitorStatusInformation> addedOrUpdated, Set<String> removed, boolean full) {
        try {
            this.monitorsMap.setStale(true);
            if (full) {
                this.monitorsMap.clear();
            }
            if (removed != null) {
                for (String id : removed) {
                    this.monitorsMap.remove((Object)id);
                }
            }
            if (addedOrUpdated != null) {
                HashMap<String, DecoratedMonitor> missing = new HashMap<String, DecoratedMonitor>();
                for (MonitorStatusInformation monitorStatusInformation : addedOrUpdated) {
                    if (this.monitorsMap.containsKey((Object)monitorStatusInformation.getId())) continue;
                    missing.put(monitorStatusInformation.getId(), new DecoratedMonitor(monitorStatusInformation));
                }
                this.monitorsMap.putAll(missing);
                for (MonitorStatusInformation monitorStatusInformation : addedOrUpdated) {
                    if (missing.keySet().contains(monitorStatusInformation.getId())) continue;
                    DecoratedMonitor dm = (DecoratedMonitor)this.monitorsMap.get((Object)monitorStatusInformation.getId());
                    if (dm == null) {
                        this.monitorsMap.put((Object)monitorStatusInformation.getId(), (Object)new DecoratedMonitor(monitorStatusInformation));
                        continue;
                    }
                    dm.setMonitor(monitorStatusInformation);
                }
            }
        }
        finally {
            this.monitorsMap.setStale(false);
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.monitorsMap = new WritableMap(SWTObservables.getRealm((Display)parent.getDisplay()));
        this.monitors = new WritableSet(SWTObservables.getRealm((Display)parent.getDisplay()));
        this.monitorsMap.addMapChangeListener(new IMapChangeListener(){

            public void handleMapChange(MapChangeEvent event) {
                HashSet<DecoratedMonitor> toRemove = new HashSet<DecoratedMonitor>();
                for (Object key : event.diff.getRemovedKeys()) {
                    toRemove.add((DecoratedMonitor)event.diff.getOldValue(key));
                }
                MonitorSubscriptionAlarmsEventsView.this.monitors.removeAll(toRemove);
                HashSet<DecoratedMonitor> toAdd = new HashSet<DecoratedMonitor>();
                for (Object key : event.diff.getAddedKeys()) {
                    toAdd.add((DecoratedMonitor)event.diff.getNewValue(key));
                }
                MonitorSubscriptionAlarmsEventsView.this.monitors.addAll(toAdd);
                for (Object key : event.diff.getChangedKeys()) {
                    MonitorSubscriptionAlarmsEventsView.this.monitors.remove(event.diff.getOldValue(key));
                    MonitorSubscriptionAlarmsEventsView.this.monitors.add(event.diff.getNewValue(key));
                }
            }
        });
        this.monitors.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                MonitorSubscriptionAlarmsEventsView.this.updateStatusBar();
            }
        });
    }

    public void acknowledgeMonitor(String monitorId, Date timestamp, CallbackHandler callbackHandler) {
        if (this.getConnection() != null && this.getConnection().getState() == ConnectionState.BOUND) {
            this.getConnection().acknowledge(monitorId, timestamp, null, callbackHandler);
        }
    }
}

