/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.views;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scada.ae.ui.views.config.ConfigurationHelper;
import org.eclipse.scada.ae.ui.views.config.MonitorViewConfiguration;
import org.eclipse.scada.ae.ui.views.views.ColumnProperties;
import org.eclipse.scada.ae.ui.views.views.Messages;
import org.eclipse.scada.ae.ui.views.views.MonitorSubscriptionAlarmsEventsView;
import org.eclipse.scada.ae.ui.views.views.MonitorsViewTable;
import org.eclipse.scada.utils.str.StringHelper;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorsView
extends MonitorSubscriptionAlarmsEventsView {
    private static final Logger logger = LoggerFactory.getLogger(MonitorsView.class);
    public static final String ID = "org.eclipse.scada.ae.ui.views.views.monitors";
    private MonitorsViewTable monitorsTable = null;
    private List<ColumnProperties> initialColumnSettings = null;
    private final Gson gson = new GsonBuilder().create();

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.monitorsTable = new MonitorsViewTable(this.getContentPane(), this.getViewSite(), 2048, this.monitors, this.initialColumnSettings);
        this.monitorsTable.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        MonitorViewConfiguration cfg = ConfigurationHelper.findMonitorViewConfiguration(this.getViewSite().getSecondaryId());
        if (cfg != null) {
            try {
                this.setConfiguration(cfg);
            }
            catch (Exception e) {
                logger.warn("Failed to apply configuration", (Throwable)e);
            }
        } else {
            logger.info("no configuration found");
        }
    }

    protected void setConfiguration(MonitorViewConfiguration cfg) throws Exception {
        this.setMonitorsId(cfg.getMonitorQueryId());
        switch (cfg.getConnectionType()) {
            case URI: {
                this.setConnectionUri(cfg.getConnectionString());
                break;
            }
            case ID: {
                this.setConnectionId(cfg.getConnectionString());
            }
        }
        if (cfg.getLabel() != null) {
            this.setPartName(cfg.getLabel());
        }
        if (this.initialColumnSettings == null) {
            this.monitorsTable.applyColumSettings(cfg.getColumns());
        }
    }

    public void setFocus() {
        this.monitorsTable.setFocus();
    }

    @Override
    protected void watchPool(String poolId) {
    }

    @Override
    protected void watchMonitors(String monitorsId) {
        this.setMonitorsId(monitorsId);
    }

    @Override
    protected void updateStatusBar() {
        this.scheduleJob(new Runnable(){

            @Override
            public void run() {
                MonitorsView.this.setStatusBarText(MonitorsView.this.createStatusLabel());
            }
        });
    }

    protected void setStatusBarText(String string) {
        if (this.getStateLabel().isDisposed()) {
            return;
        }
        this.getStateLabel().setText(string);
    }

    protected String createStatusLabel() {
        LinkedList<String> labels = new LinkedList<String>();
        labels.add(this.getLabelForConnection());
        if (this.monitorSubscriptionState != null) {
            labels.add(this.monitorSubscriptionState.toString());
        }
        if (this.monitorsId != null) {
            labels.add(String.format(Messages.MonitorsView_Label_Format_Monitors, this.monitorsId));
        } else {
            labels.add(Messages.MonitorsView_Label_Format_NoMonitors);
        }
        labels.add(String.format(Messages.MonitorsView_Label_Format_CountMonitors, this.monitors.size()));
        return StringHelper.join(labels, (String)Messages.MonitorsView_Sep);
    }

    @Override
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String s;
        super.init(site, memento);
        if (memento != null && (s = memento.getString("columnSettings")) != null) {
            this.initialColumnSettings = (List)this.gson.fromJson(s, new TypeToken<List<ColumnProperties>>(){}.getType());
        }
    }

    @Override
    public void saveState(IMemento memento) {
        memento.putString("columnSettings", this.gson.toJson(this.monitorsTable.getColumnSettings()));
        super.saveState(memento);
    }
}

