/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.common.factory;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.sec.UserInformation;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractServiceConfigurationFactory<T>
implements ConfigurationFactory {
    private final Map<String, Entry<T>> services = new HashMap<String, Entry<T>>();
    private final BundleContext context;
    private final boolean canOnlyRecreate;

    public AbstractServiceConfigurationFactory(BundleContext context) {
        this(context, false);
    }

    public AbstractServiceConfigurationFactory(BundleContext context, boolean canOnlyRecreate) {
        this.context = context;
        this.canOnlyRecreate = canOnlyRecreate;
    }

    public synchronized void dispose() {
        for (Entry<T> entry : this.services.values()) {
            this.disposeService(null, entry.getId(), entry.getService());
            this.unregisterService(entry);
        }
        this.services.clear();
    }

    protected void unregisterService(Entry<T> entry) {
        ServiceRegistration<?> handle = entry.getHandle();
        if (handle != null) {
            handle.unregister();
        }
    }

    public synchronized void delete(UserInformation userInformation, String configurationId) throws Exception {
        Entry<T> entry = this.services.remove(configurationId);
        if (entry != null) {
            this.disposeService(userInformation, configurationId, entry.getService());
            this.unregisterService(entry);
        }
    }

    public synchronized void update(UserInformation userInformation, String configurationId, Map<String, String> parameters) throws Exception {
        Entry<T> entry;
        if (this.canOnlyRecreate) {
            this.delete(userInformation, configurationId);
        }
        if ((entry = this.services.get(configurationId)) != null) {
            Entry<T> newEntry = this.updateService(userInformation, configurationId, entry, parameters);
            if (newEntry != null && newEntry != entry) {
                this.disposeService(userInformation, configurationId, entry.getService());
                this.unregisterService(entry);
                this.services.put(configurationId, newEntry);
            }
        } else {
            entry = this.createService(userInformation, configurationId, this.context, parameters);
            if (entry != null) {
                this.services.put(configurationId, entry);
            }
        }
    }

    protected abstract Entry<T> createService(UserInformation var1, String var2, BundleContext var3, Map<String, String> var4) throws Exception;

    protected abstract void disposeService(UserInformation var1, String var2, T var3);

    protected abstract Entry<T> updateService(UserInformation var1, String var2, Entry<T> var3, Map<String, String> var4) throws Exception;

    protected synchronized Entry<T> getService(String configurationId) {
        return this.services.get(configurationId);
    }

    protected static class Entry<T> {
        private final String id;
        private final T service;
        private final ServiceRegistration<?> handle;

        public Entry(String id, T service, ServiceRegistration<?> handle) {
            this.id = id;
            this.service = service;
            this.handle = handle;
        }

        public Entry(String id, T service) {
            this.id = id;
            this.service = service;
            this.handle = null;
        }

        public ServiceRegistration<?> getHandle() {
            return this.handle;
        }

        public T getService() {
            return this.service;
        }

        public String getId() {
            return this.id;
        }
    }
}

