/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.common.lib;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.common.ChangeHeartbeatDetector;
import org.eclipse.scada.configuration.component.common.lib.Helper;
import org.eclipse.scada.configuration.component.generator.AbstractDanglingGenerator;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.world.osgi.CodeFragment;
import org.eclipse.scada.configuration.world.osgi.DataType;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.ItemReference;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.configuration.world.osgi.ScriptItem;
import org.eclipse.scada.configuration.world.osgi.ScriptTimer;

public class ChangeHeartbeatDetectorGenerator
extends AbstractDanglingGenerator {
    private final ChangeHeartbeatDetector detector;
    private final String updateCodeString;
    private final String timerCodeString;

    public ChangeHeartbeatDetectorGenerator(ChangeHeartbeatDetector detector) {
        super((DataComponent)detector);
        this.detector = detector;
        this.updateCodeString = Helper.loadResource("detect.update.js");
        this.timerCodeString = Helper.loadResource("detect.timer.js");
    }

    public void createItems(ItemCreator itemCreator) {
        if (this.detector.getSourceItem() == null) {
            itemCreator.createMarker((IStatus)new Status(4, "org.eclipse.scada.configuration.component.lib", "Source item is not set"));
            return;
        }
        ScriptItem item = OsgiFactory.eINSTANCE.createScriptItem();
        CodeFragment initCode = OsgiFactory.eINSTANCE.createCodeFragment();
        initCode.setCode(String.format("heartbeatTimeout = %s; lastChange = null;", this.detector.getTimeout()));
        CodeFragment timerCode = OsgiFactory.eINSTANCE.createCodeFragment();
        timerCode.setCode(this.timerCodeString);
        CodeFragment updateCode = OsgiFactory.eINSTANCE.createCodeFragment();
        updateCode.setCode(this.updateCodeString);
        ItemReference ref = OsgiFactory.eINSTANCE.createItemReference();
        ref.setName("A");
        ref.setItem((Item)this.detector.getSourceItem().createReference());
        item.getInputs().add((Object)ref);
        ScriptTimer timer = OsgiFactory.eINSTANCE.createScriptTimer();
        timer.setPeriod(this.detector.getCheckPeriod());
        timer.setScript(timerCode);
        item.setTimer(timer);
        item.setInitScript(initCode);
        item.setUpdateScript(updateCode);
        CreationRequest req = itemCreator.addItem((Item)item);
        req.localTags(new String[]{"STATE"});
        req.dataType(DataType.BOOLEAN);
        req.customizationTags(new String[]{"input"});
        req.information("Detector state", null, null);
        this.createScriptItem(req);
    }
}

