/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.exec.generator;

import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.exec.ExecJob;
import org.eclipse.scada.configuration.component.generator.DriverGenerator;
import org.eclipse.scada.configuration.world.ExecDriver;
import org.eclipse.scada.da.exec.configuration.ConfigurationFactory;
import org.eclipse.scada.da.exec.configuration.RootType;

public abstract class ExecJobGenerator
extends DriverGenerator {
    private final ExecJob execJob;

    public ExecJobGenerator(ExecJob execJob) {
        super((DataComponent)execJob);
        this.execJob = execJob;
    }

    public ExecDriver findDriver() {
        ExecDriver driver = (ExecDriver)this.context.getDriverMap().get(this.execJob.getRunsOn());
        if (driver == null) {
            throw new IllegalStateException(String.format("ExecJob component %s has no driver assigned", this.execJob));
        }
        return driver;
    }

    public RootType findRoot() {
        ExecDriver driver = this.findDriver();
        RootType root = driver.getRoot();
        if (root != null) {
            return root;
        }
        root = ConfigurationFactory.eINSTANCE.createRootType();
        driver.setRoot(root);
        return root;
    }

    protected String jobName() {
        return "CMD." + this.getFullLevelName() + "." + this.execJob.getName();
    }

    protected String localItem(String tag) {
        return String.valueOf(this.jobName()) + "." + tag;
    }
}

